package aws

import (
	"code.justin.tv/event-engineering/golibs/pkg/logging/loggingfakes"
	"code.justin.tv/event-engineering/moonlight-daemon/pkg/aws/backend/backendfakes"
	"github.com/aws/aws-sdk-go/service/ssm"
	"github.com/stretchr/testify/assert"
	"testing"
)

// Just make sure that the right methods are being called and the data is being passed through correctly
func TestSSMPassthrough(t *testing.T) {
	t.Parallel()
	a := assert.New(t)

	fakeClient := new(backendfakes.FakeClient)
	fakeLogger := new(loggingfakes.FakeLogger)
	client := New(fakeClient, fakeLogger)

	paramName := "PARAM_NAME"

	fakeClient.SSMGetParametersStub = func(input *ssm.GetParametersInput) (*ssm.GetParametersOutput, error) {
		a.EqualValues("PARAM_NAME", *input.Names[0])

		param := "param_name"
		value := "param_value"
		return &ssm.GetParametersOutput{
			Parameters: []*ssm.Parameter{
				&ssm.Parameter{
					Name:  &param,
					Value: &value,
				},
			},
		}, nil
	}

	input := &ssm.GetParametersInput{
		Names: []*string{&paramName},
	}

	output, err := client.SSMGetParameters(input)
	a.Nil(err)
	a.EqualValues("param_value", *output.Parameters[0].Value)
	a.EqualValues(1, fakeClient.SSMGetParametersCallCount())
}
