package obs

import (
	rpc "code.justin.tv/event-engineering/moonlight-api/pkg/rpc"
	"github.com/gobuffalo/packr"
	"os"
	"path"
	"text/template"
)

func ParseScenes(scenesJSON string) ([]string, error) {
	// TODO do this :)
	return []string{"Main", "BRB", "Black"}, nil
}

// GenerateConfig will create a config directory at the specified rootDir and use the templates to create a working OBS setup
func GenerateConfig(rootDir string, config *rpc.OBSCloudInstance) error {
	// /global.ini
	// /basic/profiles/default/basic.ini
	// /basic/profiles/default/service.json
	// /basic/profiles/default/streamEncoder.json

	// /basic/scenes/default.json

	/*
	   At this point we're only generating scenes and profiles are essentially hard coded, I'm leaving the template logic as is so that we can
	   easily customise the profiles if we need to in future
	*/

	box := packr.NewBox("./templates")

	err := os.MkdirAll(path.Join(rootDir, "basic/profiles/default"), 0766)
	if err != nil {
		return err
	}

	err = os.MkdirAll(path.Join(rootDir, "basic/scenes"), 0766)
	if err != nil {
		return err
	}

	// /global.ini
	err = generateFile(box, "global.ini", path.Join(rootDir, "global.ini"), config.ObsConfig)
	if err != nil {
		return err
	}

	// /basic/profiles/default/basic.ini
	err = generateFile(box, "basic/profiles/basic.ini", path.Join(rootDir, "basic/profiles/default/basic.ini"), config.ObsConfig)
	if err != nil {
		return err
	}

	// /basic/profiles/default/service.json
	err = generateFile(box, "basic/profiles/service.json", path.Join(rootDir, "basic/profiles/default/service.json"), config.ObsConfig)
	if err != nil {
		return err
	}

	// /basic/profiles/default/streamEncoder.json
	err = generateFile(box, "basic/profiles/streamEncoder.json", path.Join(rootDir, "basic/profiles/default/streamEncoder.json"), config.ObsConfig)
	if err != nil {
		return err
	}

	// Scenes is a bit weird, the actual object we get from the db is a combination of something that's generated from user input
	// And something we need to grab from the db, so we need to do a replacement on that
	// /basic/scenes/default.json
	err = generateScenes(config.ObsConfig.GetScenesJson(), path.Join(rootDir, "basic/scenes/default.json"), config.ObsConfig)
	if err != nil {
		return err
	}

	return nil
}

func generateScenes(scenesJSON string, outputPath string, data interface{}) error {
	tmpl, err := template.New("scenes").Parse(scenesJSON)
	if err != nil {
		return err
	}

	outputFile, err := os.Create(outputPath)
	if err != nil {
		return err
	}

	defer outputFile.Close()

	err = tmpl.Execute(outputFile, data)
	if err != nil {
		return err
	}

	return nil
}

func generateFile(box packr.Box, templatePath, outputPath string, data interface{}) error {
	templateString, err := box.FindString(templatePath)
	if err != nil {
		return err
	}

	tmpl, err := template.New(templatePath).Parse(templateString)
	if err != nil {
		return err
	}

	outputFile, err := os.Create(outputPath)
	if err != nil {
		return err
	}

	defer outputFile.Close()

	err = tmpl.Execute(outputFile, data)
	if err != nil {
		return err
	}

	return nil
}
