package obs

import (
	obsws "code.justin.tv/event-engineering/obs-websocket-go/pkg/obs"
)

type ServerStatus struct {
	IsStreaming        bool
	CurrentBitrateKbps int
	CurrentScene       string
}

type SceneList struct {
	CurrentScene string
	Scenes       []string
}

type Server interface {
	StartStream(streamKey string) error
	StopStream() error
	GetSceneList() (*SceneList, error)
	SwitchScene(sceneIdentifier string) error
	GetStatus() (*ServerStatus, error)
	Close() error
	Connect() (chan error, error)
	SetHeartbeat(enable bool) error
	Subscribe() chan obsws.Event
	MuteInput(soure string, mute bool) error
	GetMuteStatus(source string) (bool, error)
	UpdateOBSConfig(url string, width, height, x, y int) error
}
