#!/usr/bin/env node
import 'source-map-support/register';
import cdk = require('@aws-cdk/core');
import { MoonlightInfraStack } from '../lib/moonlight-infra-stack';
import { MoonlightDNSStack } from '../lib/moonlight-dns-stack';

const app = new cdk.App();
new MoonlightInfraStack(app, 'dev', {
  cdkProps: {
    stackName: 'dev',
    env: {
      region: 'us-west-2',
      account: '450786683468',
    },
  },
  hostedZoneName: 'stg.moonlight.twitch.tv',
  // This CA will need to be manually created until CDK supports its creation
  moonlightRootCAARN: 'arn:aws:acm-pca:us-west-2:450786683468:certificate-authority/040eaf4b-b770-4974-99ea-591d43064c02',
  bridgeLambdaRoleARN: 'arn:aws:iam::025746400680:role/bridge-stg-BridgeAppBridgeLambdaServiceRole033B00F-Y2CQYNURP5KB',
  publicMediaURL: 'https://dd641y3fynhie.cloudfront.net/media',
  daemonAMI: {
    "us-west-2": "ami-07f0fb9efe0a04b9d"
  },
  daemonKeyPairName: "twitch-irl-dev-test",
  rtmpAMI: {
    "us-west-2": "ami-05a7784cccf41e1ab",
  },
  rtmpKeyPairName: "twitch-irl-dev-test",
  rtmpHostName: 'us-west-2.rtmp.stg.moonlight.twitch.tv',
  apiEnv: {
    TwitchClientID: "a4v0mveg21pcz47onb1443ir7k5neg",
    TwitchDevClientID: "q0h0qjfo6zrevsdaaqgmoqktffvthc",
  },
  createDevExternalAPI: true, // For our staging environment we're also exposing a /dev stage on the External API gateway that can be used when working locally
  daemonDeployBucket: "twitch-irl-dev-daemon-deploy",
  rtmpDeployBucket: "twitch-irl-dev-rtmp-deploy",
  // This allows us to pull a docker image from the production ECR repo to pre-cache the image on the AMI that gets generated in dev,
  // This is assuming that we always create / test the images on dev then give prod permission to use them directly
  alternativeECRRepositoryARN: 'arn:aws:ecr:us-west-2:638444536247:repository/moonlight',
  canAccessSystemBindleLockID: 'amzn1.bindle.resource.cvc6rxtimk6tgchn2m5a',
  adminBindleLockID: 'amzn1.bindle.resource.l26snoxwahfy3b5ejk2a',
  opsBindleLockID: 'amzn1.bindle.resource.nhnudkpinhekttbhmuuq',
});

new MoonlightInfraStack(app, 'prod', {
  cdkProps: {
    stackName: 'prod',
    env: {
      region: 'us-west-2',
      account: '638444536247',
    },
    terminationProtection: true,
  },
  hostedZoneName: 'moonlight.twitch.tv',
  // This CA will need to be manually created until CDK supports its creation
  moonlightRootCAARN: 'arn:aws:acm-pca:us-west-2:638444536247:certificate-authority/ca3835f2-4451-4004-807d-8130ad7f0aeb',
  bridgeLambdaRoleARN: 'arn:aws:iam::000132032748:role/bridge-prod-BridgeAppBridgeLambdaServiceRole033B00-PFO2R9WHK1US',
  publicMediaURL: 'https://dqfmcxpmvbs0.cloudfront.net/media',
  daemonAMI: {
    "us-west-2": "ami-07f0fb9efe0a04b9d"
  },
  daemonKeyPairName: "twitch-irl-prod-key",
  rtmpAMI: {
    "us-west-2": "ami-05a7784cccf41e1ab",
  },
  rtmpKeyPairName: "twitch-irl-prod-key",
  rtmpHostName: 'us-west-2.rtmp.moonlight.twitch.tv',
  apiEnv: {
    TwitchClientID: "ukuety07pvpbgjvuan8107yelvlwsd",
    TwitchDevClientID: "",
  },
  createDevExternalAPI: false,
  daemonDeployBucket: "twitch-irl-prod-daemon-deploy",
  rtmpDeployBucket: "twitch-irl-prod-rtmp-deploy",
  // This allows us to pull a docker image from the production ECR repo to pre-cache the image on the AMI that gets generated in dev,
  // This is assuming that we always create / test the images on dev then give prod permission to use them directly
  secondaryECRIAMRoleARN: 'arn:aws:iam::450786683468:role/dev-MoonlightDaemonMoonlightCompositeRoleC5169E01-1R5RI2EMNXNVK',
  canAccessSystemBindleLockID: 'amzn1.bindle.resource.acvilsesu7qcv7c44m4q',
  adminBindleLockID: 'amzn1.bindle.resource.qadu3dah7vqlzqmymh7a',
  opsBindleLockID: 'amzn1.bindle.resource.iqixiqwjkthrnhfi6uvq',
});

new MoonlightDNSStack(app, 'dns-dev', {
  cdkProps: {
    stackName: 'dns-dev',
    env: {
      region: 'us-west-2',
      account: '450786683468',
    }
  },
  zoneName: 'stg.moonlight.twitch.tv'
});

new MoonlightDNSStack(app, 'dns-prod', {
  cdkProps: {
    stackName: 'dns-prod',
    env: {
      region: 'us-west-2',
      account: '638444536247',
    },
    terminationProtection: true,
  },
  zoneName: 'moonlight.twitch.tv'
});
