import cdk = require('@aws-cdk/core');
import ecr = require('@aws-cdk/aws-ecr');
import iam = require('@aws-cdk/aws-iam');

export interface ECRProps {
  secondaryIAMRoleARN?: string
}


export class ContainerRepository extends cdk.Construct {
  Repository: ecr.Repository

  constructor(scope: cdk.Construct, id: string, props: ECRProps) {
    super(scope, id);

    this.Repository = new ecr.Repository(this, 'ECRRepository', {
      repositoryName: 'moonlight',
    })

    // If we've been passed this then allow this role to access this ECR repo
    if (props.secondaryIAMRoleARN) {
      this.Repository.addToResourcePolicy(new iam.PolicyStatement({
        effect: iam.Effect.ALLOW,
        principals: [new iam.ArnPrincipal(props.secondaryIAMRoleARN)],
        actions: [
          "ecr:GetLifecyclePolicyPreview",
          "ecr:GetDownloadUrlForLayer",
          "ecr:BatchGetImage",
          "ecr:DescribeImages",
          "ecr:DescribeRepositories",
          "ecr:ListTagsForResource",
          "ecr:ListImages",
          "ecr:BatchCheckLayerAvailability",
          "ecr:GetRepositoryPolicy",
          "ecr:GetLifecyclePolicy"
        ],
      }))
    }
  }
}
