import cdk = require('@aws-cdk/core');
import ddb = require('@aws-cdk/aws-dynamodb');

export class MoonlightDb extends cdk.Construct {
  InstancesTable: ddb.Table
  ServersTable: ddb.Table
  RTMPSourcesTable: ddb.Table
  UsersTable: ddb.Table

  constructor(scope: cdk.Construct, id: string) {
    super(scope, id);

    // Instances
    this.InstancesTable = new ddb.Table(this, 'MoonlightInstances', {
      partitionKey: { name: 'instance_id', type: ddb.AttributeType.STRING },
      billingMode: ddb.BillingMode.PAY_PER_REQUEST,
    })

    this.InstancesTable.addGlobalSecondaryIndex({
      indexName: 'ServerIdIndex',
      partitionKey: { name: 'server_id', type: ddb.AttributeType.STRING },
      projectionType: ddb.ProjectionType.ALL,
    })

    this.InstancesTable.addGlobalSecondaryIndex({
      indexName: 'RtmpKeyIndex',
      partitionKey: { name: 'rtmp_key', type: ddb.AttributeType.STRING },
      projectionType: ddb.ProjectionType.ALL,
    })

    this.InstancesTable.addGlobalSecondaryIndex({
      indexName: 'TwitchUserIDIndex',
      partitionKey: { name: 'twitch_user_id', type: ddb.AttributeType.STRING },
      projectionType: ddb.ProjectionType.ALL,
    })

    // Servers
    this.ServersTable = new ddb.Table(this, 'MoonlightServers', {
      partitionKey: { name: 'server_id', type: ddb.AttributeType.STRING },
      billingMode: ddb.BillingMode.PAY_PER_REQUEST,
    })

    // RTMP Sources
    this.RTMPSourcesTable = new ddb.Table(this, 'MoonlightRTMPSources', {
      partitionKey: { name: 'source_id', type: ddb.AttributeType.STRING },
      billingMode: ddb.BillingMode.PAY_PER_REQUEST,
    })

    this.RTMPSourcesTable.addGlobalSecondaryIndex({
      indexName: 'RtmpKeyIndex',
      partitionKey: { name: 'rtmp_key', type: ddb.AttributeType.STRING },
      projectionType: ddb.ProjectionType.ALL,
    })

    // Users
    this.UsersTable = new ddb.Table(this, 'MoonlightUsers', {
      partitionKey: { name: 'twitch_user_id', type: ddb.AttributeType.STRING },
      billingMode: ddb.BillingMode.PAY_PER_REQUEST,
    })
  }
}
