import cdk = require('@aws-cdk/core');
import route53 = require('@aws-cdk/aws-route53');

export interface StackProps {
  zoneName: string,
  cdkProps: cdk.StackProps
}

export class MoonlightDNSStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: StackProps) {
    super(scope, id, props.cdkProps);

    new route53.PublicHostedZone(this, 'MoonlightHostedZone', {
      zoneName: props.zoneName
    });
  }
}
