package main

import (
	adminRPC "code.justin.tv/event-engineering/moonlight-api/pkg/rpc/admin"
	"context"
	"encoding/json"
	"fmt"
	"github.com/spf13/cobra"
	"log"
)

func init() {
	rootCmd.AddCommand(getVncKeyCommand)
	getVncKeyCommand.PersistentFlags().StringP("instance", "i", "", "Moonlight Instance ID")
}

var getVncKeyCommand = &cobra.Command{
	Use:   "get_vnc_key <moonlight_instance_id>",
	Short: "Get a VNC key for the supplied moonlight instance",
	Run: func(cmd *cobra.Command, args []string) {
		instanceID := cmd.Flag("instance").Value.String()

		if instanceID == "" {
			log.Println("No instance ID specified")
			return
		}

		ctx := context.Background()
		resp, err := internalClient.GetInstanceAccessKey(ctx, &adminRPC.GetInstanceAccessKeyReq{
			InstanceId: instanceID,
		})

		if err != nil {
			log.Println(err)
			return
		}

		bytes, err := json.Marshal(resp)
		if err != nil {
			log.Print(err)
		}

		fmt.Println(string(bytes))
	},
}
