package main

import (
	twirpLambda "code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	adminRPC "code.justin.tv/event-engineering/moonlight-api/pkg/rpc/admin"
	"fmt"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials/processcreds"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lambda"
	"github.com/sirupsen/logrus"
	"github.com/spf13/cobra"
	"log"
	"os"
)

var isProd *bool
var region *string
var internalClient adminRPC.AdminController

func init() {
	isProd = rootCmd.PersistentFlags().Bool("prod", false, "Use production environment")
	region = rootCmd.PersistentFlags().String("region", "us-west-2", "AWS Region")
}

var rootCmd = &cobra.Command{
	Use:   "moonlight-ops",
	Short: "Moonlight Operations CLI, for some useful tools",
	Long:  `I'm sure you'll figure it out`,
	Run: func(cmd *cobra.Command, args []string) {
		log.Println("Available Commands:")
		log.Println("get_vnc_key")
	},
	PersistentPreRun: func(cmd *cobra.Command, args []string) {
		// Default to dev config unless the prod flag is passed
		var processCredentialsCommand = "isengard_credentials --account-id 450786683468 --role Operations"
		var moonlightInternalLambdaFunctionARN = "arn:aws:lambda:us-west-2:450786683468:function:dev-MoonlightAPIMoonlightAdminAPI6D4C0AE1-1XQ41G3WASNR5"

		if *isProd {
			processCredentialsCommand = "isengard_credentials --account-id 638444536247 --role Operations"
			moonlightInternalLambdaFunctionARN = "arn:aws:lambda:us-west-2:638444536247:function:prod-MoonlightAPIMoonlightAdminAPI6D4C0AE1-1DO6J47TGHW4Q"
		}

		logger := logrus.New()
		logger.SetLevel(logrus.DebugLevel)

		creds := processcreds.NewCredentials(processCredentialsCommand)

		// Create am AWS session
		awsSession, err := session.NewSession(&aws.Config{
			Region:      region,
			Credentials: creds,
		})

		if err != nil {
			panic(fmt.Errorf("Error creating AWS session %v", err))
		}

		lambdaClient := lambda.New(awsSession)
		lambdaTransport := twirpLambda.NewClient(lambdaClient, moonlightInternalLambdaFunctionARN)
		internalClient = adminRPC.NewAdminControllerJSONClient("https://www.doesnt.matter.because.its.actually.lambda.transport.twitch.tv", lambdaTransport)
	},
}

func main() {
	if err := rootCmd.Execute(); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}
