#!/bin/bash

# Grab parameters
instance_id="$1"

if [ -z "$instance_id" ]
then
	echo "No instance ID specified"
	exit
fi

aws_env="$2"

if [ -z "$aws_env" ]
then
  aws_env="dev"
  echo "No profile specified, using default [$aws_env]"
fi

aws_region="$3"

if [ -z "$aws_region" ]
then
  aws_region="us-west-2"
  echo "No region specified, using default [$aws_region]"
fi

pem=twitch-irl-dev-test.pem
if [ $aws_env = prod ]
then
	pem=twitch-irl-prod-key.pem
fi

echo "Using PEM file $pem"

# SSH tunnel using SSM session manager
AWS_PROFILE="twitch-irl-$aws_env" AWS_REGION=$aws_region ssh -i ~/.ssh/keys/$pem ubuntu@$instance_id
