#!/bin/bash

# Grab parameters
instance_id="$1"

if [ -z "$instance_id" ]
then
	echo "No instance ID specified"
	exit
fi

aws_env="$2"

if [ -z "$aws_env" ]
then
  aws_env="dev"
  echo "No env specified, using default [$aws_env]"
fi

aws_region="$3"

if [ -z "$aws_region" ]
then
  aws_region="us-west-2"
  echo "No region specified, using default [$aws_region]"
fi

prod_flag=""
if [ $aws_env == "prod" ]
then
	prod_flag=--prod
fi

# Call moonlight internal via the moonlight-tools CLI and grab the necessary connection info
result_json=$(../bin/moonlight-tools $prod_flag get_vnc_key -i $instance_id)
aws_instance_id=$(echo $result_json | jq -r .aws_instance_id)
remote_port=$(echo $result_json | jq .port)
access_key=$(echo $result_json | jq -r .access_key) # Hello security team, this is a single use password generated at the time of this call

# Set up the exit script
exit_script() {
    ssh -S moonlight-instance-vnc -O exit ubuntu@$aws_instance_id
}
trap exit_script EXIT

# SSH tunnel using SSM session manager, TODO - show example .ssh/config for this in README
AWS_PROFILE="twitch-irl-$aws_env" AWS_REGION=$aws_region ssh -i ~/.ssh/keys/twitch-irl-dev-test.pem -M -S moonlight-instance-vnc -fnNT -L 5337:localhost:$remote_port ubuntu@$aws_instance_id

# Open the browser to use the web VNC session
open https://localhost:5337/?password=$access_key

echo "Press Ctrl+C once you're done else the SSH tunnel will remain open"

# wait
tail -f /dev/null
