// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: pkg/rpc/internal.proto

/*
Package internal is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	pkg/rpc/internal.proto
*/
package internal

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ====================
// Controller Interface
// ====================

type Controller interface {
	GetOBSCloudConfig(context.Context, *GetOBSCloudConfigReq) (*GetOBSCloudConfigResp, error)

	SubmitRTMPEvent(context.Context, *SubmitRTMPEventReq) (*SubmitRTMPEventResp, error)

	RegisterStream(context.Context, *RegisterStreamReq) (*RegisterStreamResp, error)

	RegisterDaemon(context.Context, *RegisterDaemonReq) (*RegisterDaemonResp, error)

	DeregisterDaemon(context.Context, *DeregisterDaemonReq) (*DeregisterDaemonResp, error)

	SetStreamLive(context.Context, *SetStreamLiveReq) (*StreamOperationResp, error)

	SetStreamMute(context.Context, *SetStreamMuteReq) (*StreamOperationResp, error)

	SetStreamScene(context.Context, *SetStreamSceneReq) (*StreamOperationResp, error)

	InitialiseSession(context.Context, *InitialiseSessionReq) (*InitialiseSessionResp, error)

	GetInstanceStatus(context.Context, *GetInstanceStatusReq) (*GetInstanceStatusResp, error)

	CreateUser(context.Context, *CreateUserReq) (*CreateUserResp, error)

	CreateRTMPSource(context.Context, *CreateRTMPSourceReq) (*CreateRTMPSourceResp, error)

	GetRTMPSourceByRTMPKey(context.Context, *GetRTMPSourceByRTMPKeyReq) (*GetRTMPSourceByRTMPKeyResp, error)

	SetInstanceStatus(context.Context, *SetInstanceStatusReq) (*SetInstanceStatusResp, error)

	GetInstanceAccessKey(context.Context, *GetInstanceAccessKeyReq) (*GetInstanceAccessKeyResp, error)

	StopInstance(context.Context, *StopInstanceReq) (*StopInstanceResp, error)
}

// ==========================
// Controller Protobuf Client
// ==========================

type controllerProtobufClient struct {
	client HTTPClient
	urls   [16]string
}

// NewControllerProtobufClient creates a Protobuf client that implements the Controller interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewControllerProtobufClient(addr string, client HTTPClient) Controller {
	prefix := urlBase(addr) + ControllerPathPrefix
	urls := [16]string{
		prefix + "GetOBSCloudConfig",
		prefix + "SubmitRTMPEvent",
		prefix + "RegisterStream",
		prefix + "RegisterDaemon",
		prefix + "DeregisterDaemon",
		prefix + "SetStreamLive",
		prefix + "SetStreamMute",
		prefix + "SetStreamScene",
		prefix + "InitialiseSession",
		prefix + "GetInstanceStatus",
		prefix + "CreateUser",
		prefix + "CreateRTMPSource",
		prefix + "GetRTMPSourceByRTMPKey",
		prefix + "SetInstanceStatus",
		prefix + "GetInstanceAccessKey",
		prefix + "StopInstance",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &controllerProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &controllerProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *controllerProtobufClient) GetOBSCloudConfig(ctx context.Context, in *GetOBSCloudConfigReq) (*GetOBSCloudConfigResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "GetOBSCloudConfig")
	out := new(GetOBSCloudConfigResp)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *controllerProtobufClient) SubmitRTMPEvent(ctx context.Context, in *SubmitRTMPEventReq) (*SubmitRTMPEventResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SubmitRTMPEvent")
	out := new(SubmitRTMPEventResp)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *controllerProtobufClient) RegisterStream(ctx context.Context, in *RegisterStreamReq) (*RegisterStreamResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterStream")
	out := new(RegisterStreamResp)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *controllerProtobufClient) RegisterDaemon(ctx context.Context, in *RegisterDaemonReq) (*RegisterDaemonResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterDaemon")
	out := new(RegisterDaemonResp)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *controllerProtobufClient) DeregisterDaemon(ctx context.Context, in *DeregisterDaemonReq) (*DeregisterDaemonResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterDaemon")
	out := new(DeregisterDaemonResp)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *controllerProtobufClient) SetStreamLive(ctx context.Context, in *SetStreamLiveReq) (*StreamOperationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamLive")
	out := new(StreamOperationResp)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *controllerProtobufClient) SetStreamMute(ctx context.Context, in *SetStreamMuteReq) (*StreamOperationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamMute")
	out := new(StreamOperationResp)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *controllerProtobufClient) SetStreamScene(ctx context.Context, in *SetStreamSceneReq) (*StreamOperationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamScene")
	out := new(StreamOperationResp)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *controllerProtobufClient) InitialiseSession(ctx context.Context, in *InitialiseSessionReq) (*InitialiseSessionResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "InitialiseSession")
	out := new(InitialiseSessionResp)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *controllerProtobufClient) GetInstanceStatus(ctx context.Context, in *GetInstanceStatusReq) (*GetInstanceStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "GetInstanceStatus")
	out := new(GetInstanceStatusResp)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *controllerProtobufClient) CreateUser(ctx context.Context, in *CreateUserReq) (*CreateUserResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "CreateUser")
	out := new(CreateUserResp)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *controllerProtobufClient) CreateRTMPSource(ctx context.Context, in *CreateRTMPSourceReq) (*CreateRTMPSourceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRTMPSource")
	out := new(CreateRTMPSourceResp)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *controllerProtobufClient) GetRTMPSourceByRTMPKey(ctx context.Context, in *GetRTMPSourceByRTMPKeyReq) (*GetRTMPSourceByRTMPKeyResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "GetRTMPSourceByRTMPKey")
	out := new(GetRTMPSourceByRTMPKeyResp)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *controllerProtobufClient) SetInstanceStatus(ctx context.Context, in *SetInstanceStatusReq) (*SetInstanceStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SetInstanceStatus")
	out := new(SetInstanceStatusResp)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *controllerProtobufClient) GetInstanceAccessKey(ctx context.Context, in *GetInstanceAccessKeyReq) (*GetInstanceAccessKeyResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "GetInstanceAccessKey")
	out := new(GetInstanceAccessKeyResp)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *controllerProtobufClient) StopInstance(ctx context.Context, in *StopInstanceReq) (*StopInstanceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "StopInstance")
	out := new(StopInstanceResp)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

// ======================
// Controller JSON Client
// ======================

type controllerJSONClient struct {
	client HTTPClient
	urls   [16]string
}

// NewControllerJSONClient creates a JSON client that implements the Controller interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewControllerJSONClient(addr string, client HTTPClient) Controller {
	prefix := urlBase(addr) + ControllerPathPrefix
	urls := [16]string{
		prefix + "GetOBSCloudConfig",
		prefix + "SubmitRTMPEvent",
		prefix + "RegisterStream",
		prefix + "RegisterDaemon",
		prefix + "DeregisterDaemon",
		prefix + "SetStreamLive",
		prefix + "SetStreamMute",
		prefix + "SetStreamScene",
		prefix + "InitialiseSession",
		prefix + "GetInstanceStatus",
		prefix + "CreateUser",
		prefix + "CreateRTMPSource",
		prefix + "GetRTMPSourceByRTMPKey",
		prefix + "SetInstanceStatus",
		prefix + "GetInstanceAccessKey",
		prefix + "StopInstance",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &controllerJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &controllerJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *controllerJSONClient) GetOBSCloudConfig(ctx context.Context, in *GetOBSCloudConfigReq) (*GetOBSCloudConfigResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "GetOBSCloudConfig")
	out := new(GetOBSCloudConfigResp)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *controllerJSONClient) SubmitRTMPEvent(ctx context.Context, in *SubmitRTMPEventReq) (*SubmitRTMPEventResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SubmitRTMPEvent")
	out := new(SubmitRTMPEventResp)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *controllerJSONClient) RegisterStream(ctx context.Context, in *RegisterStreamReq) (*RegisterStreamResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterStream")
	out := new(RegisterStreamResp)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *controllerJSONClient) RegisterDaemon(ctx context.Context, in *RegisterDaemonReq) (*RegisterDaemonResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterDaemon")
	out := new(RegisterDaemonResp)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *controllerJSONClient) DeregisterDaemon(ctx context.Context, in *DeregisterDaemonReq) (*DeregisterDaemonResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterDaemon")
	out := new(DeregisterDaemonResp)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *controllerJSONClient) SetStreamLive(ctx context.Context, in *SetStreamLiveReq) (*StreamOperationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamLive")
	out := new(StreamOperationResp)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *controllerJSONClient) SetStreamMute(ctx context.Context, in *SetStreamMuteReq) (*StreamOperationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamMute")
	out := new(StreamOperationResp)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *controllerJSONClient) SetStreamScene(ctx context.Context, in *SetStreamSceneReq) (*StreamOperationResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamScene")
	out := new(StreamOperationResp)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *controllerJSONClient) InitialiseSession(ctx context.Context, in *InitialiseSessionReq) (*InitialiseSessionResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "InitialiseSession")
	out := new(InitialiseSessionResp)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *controllerJSONClient) GetInstanceStatus(ctx context.Context, in *GetInstanceStatusReq) (*GetInstanceStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "GetInstanceStatus")
	out := new(GetInstanceStatusResp)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *controllerJSONClient) CreateUser(ctx context.Context, in *CreateUserReq) (*CreateUserResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "CreateUser")
	out := new(CreateUserResp)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *controllerJSONClient) CreateRTMPSource(ctx context.Context, in *CreateRTMPSourceReq) (*CreateRTMPSourceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRTMPSource")
	out := new(CreateRTMPSourceResp)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *controllerJSONClient) GetRTMPSourceByRTMPKey(ctx context.Context, in *GetRTMPSourceByRTMPKeyReq) (*GetRTMPSourceByRTMPKeyResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "GetRTMPSourceByRTMPKey")
	out := new(GetRTMPSourceByRTMPKeyResp)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

func (c *controllerJSONClient) SetInstanceStatus(ctx context.Context, in *SetInstanceStatusReq) (*SetInstanceStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "SetInstanceStatus")
	out := new(SetInstanceStatusResp)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	return out, err
}

func (c *controllerJSONClient) GetInstanceAccessKey(ctx context.Context, in *GetInstanceAccessKeyReq) (*GetInstanceAccessKeyResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "GetInstanceAccessKey")
	out := new(GetInstanceAccessKeyResp)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	return out, err
}

func (c *controllerJSONClient) StopInstance(ctx context.Context, in *StopInstanceReq) (*StopInstanceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithMethodName(ctx, "StopInstance")
	out := new(StopInstanceResp)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	return out, err
}

// =========================
// Controller Server Handler
// =========================

type controllerServer struct {
	Controller
	hooks *twirp.ServerHooks
}

func NewControllerServer(svc Controller, hooks *twirp.ServerHooks) TwirpServer {
	return &controllerServer{
		Controller: svc,
		hooks:      hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *controllerServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ControllerPathPrefix is used for all URL paths on a twirp Controller server.
// Requests are always: POST ControllerPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ControllerPathPrefix = "/twirp/internal.Controller/"

func (s *controllerServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "internal")
	ctx = ctxsetters.WithServiceName(ctx, "Controller")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/internal.Controller/GetOBSCloudConfig":
		s.serveGetOBSCloudConfig(ctx, resp, req)
		return
	case "/twirp/internal.Controller/SubmitRTMPEvent":
		s.serveSubmitRTMPEvent(ctx, resp, req)
		return
	case "/twirp/internal.Controller/RegisterStream":
		s.serveRegisterStream(ctx, resp, req)
		return
	case "/twirp/internal.Controller/RegisterDaemon":
		s.serveRegisterDaemon(ctx, resp, req)
		return
	case "/twirp/internal.Controller/DeregisterDaemon":
		s.serveDeregisterDaemon(ctx, resp, req)
		return
	case "/twirp/internal.Controller/SetStreamLive":
		s.serveSetStreamLive(ctx, resp, req)
		return
	case "/twirp/internal.Controller/SetStreamMute":
		s.serveSetStreamMute(ctx, resp, req)
		return
	case "/twirp/internal.Controller/SetStreamScene":
		s.serveSetStreamScene(ctx, resp, req)
		return
	case "/twirp/internal.Controller/InitialiseSession":
		s.serveInitialiseSession(ctx, resp, req)
		return
	case "/twirp/internal.Controller/GetInstanceStatus":
		s.serveGetInstanceStatus(ctx, resp, req)
		return
	case "/twirp/internal.Controller/CreateUser":
		s.serveCreateUser(ctx, resp, req)
		return
	case "/twirp/internal.Controller/CreateRTMPSource":
		s.serveCreateRTMPSource(ctx, resp, req)
		return
	case "/twirp/internal.Controller/GetRTMPSourceByRTMPKey":
		s.serveGetRTMPSourceByRTMPKey(ctx, resp, req)
		return
	case "/twirp/internal.Controller/SetInstanceStatus":
		s.serveSetInstanceStatus(ctx, resp, req)
		return
	case "/twirp/internal.Controller/GetInstanceAccessKey":
		s.serveGetInstanceAccessKey(ctx, resp, req)
		return
	case "/twirp/internal.Controller/StopInstance":
		s.serveStopInstance(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *controllerServer) serveGetOBSCloudConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetOBSCloudConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetOBSCloudConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveGetOBSCloudConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOBSCloudConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetOBSCloudConfigReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetOBSCloudConfigResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetOBSCloudConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOBSCloudConfigResp and nil error while calling GetOBSCloudConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveGetOBSCloudConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOBSCloudConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetOBSCloudConfigReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetOBSCloudConfigResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetOBSCloudConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOBSCloudConfigResp and nil error while calling GetOBSCloudConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSubmitRTMPEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSubmitRTMPEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSubmitRTMPEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveSubmitRTMPEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SubmitRTMPEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SubmitRTMPEventReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitRTMPEventResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitRTMPEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitRTMPEventResp and nil error while calling SubmitRTMPEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSubmitRTMPEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SubmitRTMPEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SubmitRTMPEventReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitRTMPEventResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitRTMPEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitRTMPEventResp and nil error while calling SubmitRTMPEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveRegisterStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveRegisterStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RegisterStreamReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RegisterStreamResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RegisterStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterStreamResp and nil error while calling RegisterStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveRegisterStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RegisterStreamReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RegisterStreamResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RegisterStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterStreamResp and nil error while calling RegisterStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveRegisterDaemon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterDaemonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterDaemonProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveRegisterDaemonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterDaemon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RegisterDaemonReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RegisterDaemonResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RegisterDaemon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterDaemonResp and nil error while calling RegisterDaemon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveRegisterDaemonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterDaemon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RegisterDaemonReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RegisterDaemonResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RegisterDaemon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RegisterDaemonResp and nil error while calling RegisterDaemon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveDeregisterDaemon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeregisterDaemonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeregisterDaemonProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveDeregisterDaemonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterDaemon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeregisterDaemonReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeregisterDaemonResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeregisterDaemon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeregisterDaemonResp and nil error while calling DeregisterDaemon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveDeregisterDaemonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterDaemon")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeregisterDaemonReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeregisterDaemonResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeregisterDaemon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeregisterDaemonResp and nil error while calling DeregisterDaemon. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSetStreamLive(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetStreamLiveJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetStreamLiveProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveSetStreamLiveJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamLive")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetStreamLiveReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamOperationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStreamLive(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamOperationResp and nil error while calling SetStreamLive. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSetStreamLiveProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamLive")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetStreamLiveReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamOperationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStreamLive(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamOperationResp and nil error while calling SetStreamLive. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSetStreamMute(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetStreamMuteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetStreamMuteProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveSetStreamMuteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamMute")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetStreamMuteReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamOperationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStreamMute(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamOperationResp and nil error while calling SetStreamMute. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSetStreamMuteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamMute")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetStreamMuteReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamOperationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStreamMute(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamOperationResp and nil error while calling SetStreamMute. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSetStreamScene(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetStreamSceneJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetStreamSceneProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveSetStreamSceneJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamScene")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetStreamSceneReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamOperationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStreamScene(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamOperationResp and nil error while calling SetStreamScene. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSetStreamSceneProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetStreamScene")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetStreamSceneReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamOperationResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetStreamScene(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamOperationResp and nil error while calling SetStreamScene. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveInitialiseSession(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInitialiseSessionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInitialiseSessionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveInitialiseSessionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InitialiseSession")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InitialiseSessionReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InitialiseSessionResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InitialiseSession(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InitialiseSessionResp and nil error while calling InitialiseSession. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveInitialiseSessionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InitialiseSession")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InitialiseSessionReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InitialiseSessionResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InitialiseSession(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InitialiseSessionResp and nil error while calling InitialiseSession. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveGetInstanceStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetInstanceStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetInstanceStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveGetInstanceStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInstanceStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetInstanceStatusReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetInstanceStatusResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetInstanceStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInstanceStatusResp and nil error while calling GetInstanceStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveGetInstanceStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInstanceStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetInstanceStatusReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetInstanceStatusResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetInstanceStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInstanceStatusResp and nil error while calling GetInstanceStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveCreateUser(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateUserJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateUserProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveCreateUserJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateUserReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateUserResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateUserResp and nil error while calling CreateUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveCreateUserProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateUser")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateUserReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateUserResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateUser(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateUserResp and nil error while calling CreateUser. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveCreateRTMPSource(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateRTMPSourceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateRTMPSourceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveCreateRTMPSourceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRTMPSource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateRTMPSourceReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateRTMPSourceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateRTMPSource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRTMPSourceResp and nil error while calling CreateRTMPSource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveCreateRTMPSourceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRTMPSource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateRTMPSourceReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateRTMPSourceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateRTMPSource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateRTMPSourceResp and nil error while calling CreateRTMPSource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveGetRTMPSourceByRTMPKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRTMPSourceByRTMPKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRTMPSourceByRTMPKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveGetRTMPSourceByRTMPKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRTMPSourceByRTMPKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRTMPSourceByRTMPKeyReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRTMPSourceByRTMPKeyResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRTMPSourceByRTMPKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRTMPSourceByRTMPKeyResp and nil error while calling GetRTMPSourceByRTMPKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveGetRTMPSourceByRTMPKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRTMPSourceByRTMPKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRTMPSourceByRTMPKeyReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRTMPSourceByRTMPKeyResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRTMPSourceByRTMPKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRTMPSourceByRTMPKeyResp and nil error while calling GetRTMPSourceByRTMPKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSetInstanceStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetInstanceStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetInstanceStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveSetInstanceStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetInstanceStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetInstanceStatusReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetInstanceStatusResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetInstanceStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetInstanceStatusResp and nil error while calling SetInstanceStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveSetInstanceStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetInstanceStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetInstanceStatusReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetInstanceStatusResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetInstanceStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetInstanceStatusResp and nil error while calling SetInstanceStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveGetInstanceAccessKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetInstanceAccessKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetInstanceAccessKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveGetInstanceAccessKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInstanceAccessKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetInstanceAccessKeyReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetInstanceAccessKeyResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetInstanceAccessKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInstanceAccessKeyResp and nil error while calling GetInstanceAccessKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveGetInstanceAccessKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetInstanceAccessKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetInstanceAccessKeyReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetInstanceAccessKeyResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetInstanceAccessKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetInstanceAccessKeyResp and nil error while calling GetInstanceAccessKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveStopInstance(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStopInstanceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStopInstanceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *controllerServer) serveStopInstanceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StopInstance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StopInstanceReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StopInstanceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StopInstance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StopInstanceResp and nil error while calling StopInstance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) serveStopInstanceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StopInstance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StopInstanceReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StopInstanceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.StopInstance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StopInstanceResp and nil error while calling StopInstance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *controllerServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *controllerServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	if host := req.Header.Get("Host"); host != "" {
		req.Host = host
	}
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1245 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0x4b, 0x53, 0xdc, 0xc6,
	0x13, 0xff, 0x6b, 0xc1, 0x98, 0x6d, 0x1e, 0xbb, 0xf4, 0x2e, 0xb0, 0xc8, 0x18, 0xf3, 0x9f, 0xb8,
	0x52, 0x24, 0x07, 0x13, 0x20, 0xa9, 0xa4, 0x7c, 0x49, 0x01, 0x4b, 0xc8, 0xf2, 0xb4, 0x57, 0xf8,
	0x98, 0xa2, 0x64, 0x69, 0xc0, 0x2a, 0x58, 0x49, 0x68, 0x66, 0xa1, 0xb8, 0x25, 0x97, 0x7c, 0x82,
	0xdc, 0x72, 0x77, 0x55, 0xbe, 0x65, 0x6a, 0x66, 0xf4, 0x18, 0x69, 0xc5, 0x2e, 0xe6, 0x90, 0x9b,
	0xba, 0xa7, 0xfb, 0xd7, 0x3d, 0xdd, 0x3d, 0x3d, 0x3d, 0x82, 0x85, 0xf0, 0xea, 0x72, 0x3d, 0x0a,
	0x9d, 0x75, 0xcf, 0xe7, 0x34, 0xf2, 0xed, 0xeb, 0x37, 0x61, 0x14, 0xf0, 0x00, 0x27, 0x13, 0x9a,
	0x6c, 0x40, 0xcd, 0xe2, 0x41, 0xd8, 0xf1, 0x19, 0xb7, 0x7d, 0x87, 0x76, 0xe9, 0x0d, 0xae, 0x00,
	0x24, 0x64, 0xa7, 0xdd, 0x32, 0x56, 0x8d, 0xb5, 0x6a, 0x57, 0xe3, 0x90, 0x5f, 0xa0, 0x9e, 0x57,
	0x61, 0x21, 0xb6, 0xe0, 0xb9, 0xd5, 0x77, 0x1c, 0xca, 0x98, 0x54, 0x98, 0xec, 0x26, 0xa4, 0x58,
	0x39, 0xa6, 0x8c, 0xd9, 0x97, 0xb4, 0x55, 0x91, 0x50, 0x09, 0x49, 0xde, 0xc2, 0xe2, 0x3e, 0xe5,
	0x09, 0xcc, 0xb6, 0x14, 0x3f, 0xa4, 0xf7, 0xc2, 0x85, 0x57, 0x30, 0xe5, 0xc5, 0xfc, 0x73, 0xcf,
	0x4d, 0x7c, 0x48, 0x58, 0x1d, 0x97, 0xf4, 0xa1, 0x55, 0xae, 0xcb, 0x42, 0xfc, 0x1a, 0x6a, 0xf6,
	0x1d, 0x3b, 0x1f, 0x04, 0x98, 0xb1, 0xef, 0x58, 0xba, 0x0f, 0x17, 0x5f, 0x02, 0xd8, 0x52, 0xf1,
	0xfc, 0x8a, 0xde, 0xc7, 0xce, 0x55, 0xed, 0x04, 0x0a, 0x11, 0xc6, 0xc3, 0x20, 0xe2, 0xad, 0xb1,
	0x55, 0x63, 0xed, 0x59, 0x57, 0x7e, 0x93, 0x1f, 0x60, 0x69, 0x9f, 0xf2, 0xee, 0xd9, 0xf1, 0x3b,
	0x2b, 0xe8, 0x47, 0x0e, 0xdd, 0xb9, 0x17, 0xdf, 0xb1, 0xd3, 0x2d, 0x78, 0x1e, 0x53, 0xb1, 0xbd,
	0x84, 0x24, 0x7f, 0x1a, 0x60, 0x3e, 0xa4, 0xf7, 0xb4, 0xe0, 0xe1, 0xf7, 0x00, 0x19, 0x9c, 0xf4,
	0x71, 0x6a, 0xb3, 0xf9, 0x26, 0x4d, 0x73, 0xb6, 0xd6, 0xd5, 0xe4, 0xc8, 0x85, 0xae, 0x85, 0x26,
	0x4c, 0xaa, 0xaf, 0x34, 0xcd, 0x29, 0xad, 0x6f, 0xa6, 0x92, 0xdb, 0x0c, 0x12, 0x98, 0xee, 0xc4,
	0x66, 0xb6, 0x5d, 0x37, 0x92, 0xb6, 0xab, 0xdd, 0x1c, 0x8f, 0x1c, 0xc3, 0x5c, 0x97, 0x5e, 0x7a,
	0x8c, 0xd3, 0xc8, 0xe2, 0x11, 0xb5, 0x7b, 0x43, 0xe3, 0x23, 0x2a, 0xee, 0x48, 0x08, 0xfb, 0x12,
	0x50, 0xd9, 0xd3, 0x38, 0xe4, 0x57, 0xc0, 0x22, 0xdc, 0x13, 0x6b, 0xee, 0x04, 0x9a, 0x56, 0x56,
	0x37, 0x16, 0xb7, 0x79, 0x9f, 0x3d, 0xa2, 0xe6, 0x71, 0x01, 0x26, 0x94, 0x70, 0x0c, 0x18, 0x53,
	0x64, 0x11, 0xe6, 0x4b, 0xf0, 0x58, 0x48, 0xde, 0x42, 0x73, 0xbf, 0xcc, 0x10, 0x81, 0xe9, 0xb3,
	0x3b, 0x8f, 0x3b, 0x9f, 0x3e, 0x30, 0x1a, 0xa5, 0xa6, 0x72, 0x3c, 0xb2, 0x0e, 0xf3, 0xfb, 0x65,
	0xa0, 0x9a, 0x17, 0x46, 0xce, 0x8b, 0x0d, 0x68, 0xec, 0x46, 0xd4, 0xe6, 0x54, 0x4b, 0x3b, 0xbd,
	0x19, 0x96, 0x5f, 0xf2, 0xbb, 0x01, 0xcd, 0x41, 0x9d, 0xff, 0xb4, 0x18, 0xb7, 0x60, 0x46, 0x79,
	0x20, 0xb6, 0xfd, 0xd8, 0xd8, 0xb4, 0x61, 0x56, 0x57, 0x7a, 0x72, 0xeb, 0x69, 0x76, 0x7c, 0x8f,
	0x7b, 0xf6, 0xb5, 0xc7, 0xa8, 0x45, 0x19, 0xf3, 0x02, 0xff, 0xb1, 0x1e, 0xfc, 0x65, 0xc0, 0x7c,
	0x89, 0x32, 0x0b, 0x47, 0x16, 0xd1, 0xae, 0x38, 0x39, 0x31, 0xe5, 0x5f, 0x04, 0xd2, 0xa9, 0xa9,
	0xcd, 0x57, 0x59, 0xa0, 0x4a, 0xb3, 0xde, 0xcd, 0x29, 0xc9, 0x1a, 0x70, 0xa8, 0x4f, 0x59, 0x6b,
	0x6c, 0x75, 0x4c, 0xd6, 0x80, 0xa4, 0x88, 0x0d, 0x73, 0x16, 0xe5, 0xea, 0x78, 0x48, 0xd6, 0x23,
	0xf7, 0x83, 0x6b, 0x50, 0x93, 0xf2, 0x1d, 0x97, 0xfa, 0xdc, 0xbb, 0xf0, 0x68, 0x72, 0x02, 0x8b,
	0x6c, 0x72, 0x00, 0xf5, 0xd4, 0xc4, 0x71, 0x9f, 0x3f, 0xda, 0x02, 0xc2, 0xb8, 0x10, 0x97, 0xb0,
	0x93, 0x5d, 0xf9, 0x4d, 0x3e, 0x69, 0x58, 0x47, 0xde, 0xed, 0x97, 0x60, 0x09, 0xf1, 0x04, 0x4b,
	0x7c, 0xe3, 0x32, 0x54, 0x15, 0x90, 0x68, 0x2d, 0xaa, 0x1d, 0x65, 0x0c, 0xd2, 0x81, 0x86, 0x22,
	0x4e, 0x43, 0x1a, 0xd9, 0x3c, 0x49, 0xd6, 0x53, 0xca, 0x66, 0x3f, 0x6b, 0x6b, 0x6d, 0x9b, 0xf6,
	0x54, 0xcd, 0x88, 0x53, 0x46, 0xa3, 0x5b, 0xcd, 0xe3, 0x94, 0x16, 0xc9, 0xda, 0x7e, 0xd7, 0xf9,
	0xd0, 0x3d, 0x4a, 0xda, 0x86, 0xa2, 0xc8, 0x1f, 0x46, 0xd6, 0xd1, 0x12, 0x24, 0xe5, 0x13, 0xcb,
	0xfb, 0xc4, 0x32, 0x9f, 0x7a, 0x79, 0x9f, 0x62, 0x12, 0x7f, 0x84, 0x09, 0x27, 0xf0, 0x2f, 0xbc,
	0xcb, 0xf8, 0xdc, 0xe5, 0xcb, 0xe9, 0x74, 0xc7, 0xda, 0xbd, 0x0e, 0xfa, 0xee, 0xae, 0x14, 0x91,
	0xe5, 0x14, 0x8b, 0x8b, 0xa6, 0xd1, 0xa6, 0xd1, 0x97, 0x6c, 0x87, 0x1c, 0x40, 0x73, 0x50, 0xe5,
	0x69, 0x7e, 0x93, 0x2d, 0xd9, 0x20, 0x8b, 0xfe, 0xdd, 0xe0, 0x0b, 0xa8, 0x32, 0x69, 0x2f, 0xbb,
	0xb7, 0x27, 0x15, 0xa3, 0xe3, 0x92, 0xf7, 0xb2, 0x33, 0x0e, 0x6e, 0x0a, 0x7f, 0x82, 0x6a, 0x72,
	0xdf, 0x0b, 0x1f, 0xc6, 0xd6, 0xa6, 0x36, 0xcd, 0x2c, 0x10, 0x89, 0x42, 0x3a, 0xb2, 0x64, 0xc2,
	0xe4, 0x6f, 0x03, 0xea, 0xc5, 0x75, 0x9c, 0x85, 0x4a, 0xba, 0xfd, 0x4a, 0xa7, 0x9d, 0x0b, 0x4a,
	0xa5, 0x90, 0xe3, 0x35, 0xa8, 0xb5, 0x03, 0xe7, 0x8a, 0x46, 0x9d, 0x9e, 0x7d, 0x49, 0x4f, 0xec,
	0x1e, 0x8d, 0x6b, 0xb0, 0xc8, 0xc6, 0x0d, 0xa8, 0x0a, 0x4b, 0x2a, 0x5b, 0xe3, 0x32, 0x5b, 0x8d,
	0xbc, 0x93, 0x6a, 0x43, 0x99, 0x14, 0xf9, 0xc7, 0xd0, 0x74, 0x44, 0x83, 0x51, 0xa7, 0xfd, 0xc0,
	0x3a, 0x3d, 0x49, 0x1a, 0x4c, 0xc6, 0xc1, 0xd7, 0x30, 0x93, 0xf5, 0xd7, 0xac, 0xea, 0xf2, 0x4c,
	0x21, 0xb5, 0xdd, 0x77, 0xbd, 0xa0, 0x4d, 0x6f, 0x3d, 0xd9, 0xa9, 0x94, 0xbb, 0x79, 0x26, 0x7e,
	0x07, 0x0d, 0x8d, 0x91, 0xca, 0x8e, 0x4b, 0xd9, 0xb2, 0x25, 0x72, 0x07, 0x68, 0xf5, 0x3f, 0xf6,
	0x3c, 0x39, 0xe7, 0xec, 0xdd, 0x52, 0x9f, 0x8f, 0x3a, 0x1e, 0x62, 0x4d, 0x1e, 0x4d, 0x2d, 0xac,
	0x31, 0x8d, 0xdf, 0xc0, 0x33, 0x89, 0x21, 0xbd, 0x9b, 0xd5, 0x03, 0x95, 0xc1, 0x2b, 0x09, 0xb2,
	0x0e, 0x8d, 0x01, 0xc3, 0xaa, 0x2a, 0x25, 0x91, 0x1a, 0x4e, 0xc8, 0x6f, 0x3f, 0x1b, 0x50, 0x4d,
	0x65, 0x71, 0x0e, 0x66, 0xe2, 0xb6, 0xc9, 0xed, 0x88, 0x53, 0xb7, 0xfe, 0x3f, 0x5c, 0x00, 0x54,
	0xac, 0xb6, 0xc7, 0x9c, 0xc0, 0xf7, 0xa9, 0x23, 0xf8, 0x06, 0xd6, 0x60, 0x4a, 0xf1, 0xf7, 0x7c,
	0x97, 0xba, 0xf5, 0x0a, 0x2e, 0xc1, 0x7c, 0xa6, 0x7b, 0x2b, 0xbb, 0x8b, 0x44, 0xa9, 0x8f, 0xe1,
	0x62, 0xd2, 0x77, 0xb2, 0xa5, 0x3d, 0xdf, 0xad, 0x8f, 0x63, 0x53, 0xcc, 0xcf, 0x62, 0x61, 0xc7,
	0xe3, 0x91, 0xcd, 0xe9, 0x51, 0x70, 0x57, 0x7f, 0x86, 0x0d, 0x31, 0x88, 0x6b, 0xdc, 0xd3, 0xc3,
	0xfa, 0xc4, 0xe6, 0x67, 0x00, 0xd8, 0x0d, 0x7c, 0x1e, 0x05, 0xd7, 0xd7, 0x34, 0xc2, 0x33, 0x98,
	0x1b, 0x28, 0x7f, 0x5c, 0x19, 0x7a, 0xe0, 0x6f, 0xcc, 0x51, 0x0d, 0x01, 0x4f, 0xa0, 0x56, 0x08,
	0x1f, 0x2e, 0x67, 0x3a, 0x83, 0x29, 0x35, 0x5f, 0x0e, 0x59, 0x65, 0x21, 0x1e, 0xc2, 0x6c, 0x7e,
	0x5a, 0xc3, 0x17, 0x5a, 0xf2, 0x8a, 0x63, 0xa1, 0xb9, 0xfc, 0xf0, 0x62, 0x1e, 0x4c, 0x35, 0x9c,
	0x32, 0xb0, 0xb4, 0x7b, 0x95, 0x81, 0x69, 0x7d, 0xea, 0x3d, 0xd4, 0x8b, 0xfd, 0x0b, 0xb5, 0xcd,
	0x94, 0xb4, 0x43, 0x73, 0x65, 0xd8, 0x32, 0x0b, 0xf1, 0x00, 0x66, 0x72, 0xf7, 0x18, 0x6a, 0x6d,
	0xa7, 0x78, 0xc1, 0xe5, 0x02, 0x57, 0x72, 0x25, 0xe9, 0x58, 0xe2, 0x92, 0x2c, 0xc5, 0x8a, 0x2f,
	0xde, 0x51, 0x58, 0x47, 0x30, 0x9b, 0x1f, 0x07, 0xf4, 0xb8, 0x0d, 0x0c, 0x0a, 0xa3, 0xd0, 0xce,
	0x60, 0x6e, 0x60, 0xe4, 0xd1, 0x0b, 0xaf, 0x6c, 0x98, 0xd2, 0x0b, 0xaf, 0x7c, 0x5e, 0x52, 0xe5,
	0x9c, 0x9f, 0x78, 0x0a, 0xe5, 0x3c, 0x30, 0x40, 0x9b, 0xa3, 0xc6, 0x25, 0xfc, 0x19, 0x20, 0x9b,
	0x10, 0x71, 0x31, 0x13, 0xcf, 0x0d, 0x9b, 0x66, 0xab, 0x7c, 0x41, 0x55, 0x49, 0x71, 0x32, 0xd6,
	0xab, 0xa4, 0x64, 0xd2, 0xd6, 0xab, 0xa4, 0x74, 0xa8, 0x76, 0x60, 0xa1, 0xfc, 0xfd, 0x87, 0x5f,
	0xe5, 0xb6, 0x53, 0xfe, 0xb2, 0x34, 0x5f, 0x8f, 0x16, 0x52, 0xe1, 0xb4, 0x86, 0x85, 0xd3, 0x1a,
	0x11, 0xce, 0xd2, 0x87, 0x0c, 0xfe, 0x96, 0x7b, 0xc8, 0xa4, 0x2f, 0x6d, 0xfc, 0x7f, 0x69, 0x1e,
	0xf4, 0x57, 0xbc, 0x49, 0x46, 0x89, 0xb0, 0x10, 0xf7, 0x60, 0x5a, 0xff, 0x99, 0x80, 0x4b, 0x7a,
	0x21, 0xe6, 0xfe, 0x4b, 0x98, 0xe6, 0x43, 0x4b, 0x2c, 0xfc, 0x38, 0x21, 0xff, 0x6b, 0x6c, 0xfd,
	0x1b, 0x00, 0x00, 0xff, 0xff, 0x6a, 0x1b, 0xf6, 0x07, 0xf1, 0x10, 0x00, 0x00,
}
