package aws

import (
	logging "code.justin.tv/event-engineering/golibs/pkg/logging"
	"code.justin.tv/event-engineering/moonlight-rtmp/pkg/aws/backend"
	"github.com/aws/aws-sdk-go/aws/ec2metadata"
	"github.com/aws/aws-sdk-go/service/lambda/lambdaiface"
	"github.com/aws/aws-sdk-go/service/ssm"
	"time"
)

var presignedURLExpiry = 7 * 24 * time.Hour

// New generates a new AWS Client with the supplied backend client
func New(awsClient backend.Client, logger logging.Logger) *Client {
	return &Client{
		aws:    awsClient,
		logger: logger,
	}
}

// Client is an AWS client containing methods for use in the goldengate system
type Client struct {
	aws    backend.Client
	logger logging.Logger
}

// GetLambdaClient returns the lambda client for use in twirp lambda transport
func (c *Client) GetLambdaClient() lambdaiface.LambdaAPI {
	return c.aws.GetLambdaClient()
}

// SSMGetParameters calls the underlying SSMGetParameters from the aws backend
func (c *Client) SSMGetParameters(input *ssm.GetParametersInput) (*ssm.GetParametersOutput, error) {
	return c.aws.SSMGetParameters(input)
}

// EC2MGetInstanceIdentityDocument calls the underlying EC2MGetInstanceIdentityDocument from the aws backend
func (c *Client) EC2MGetInstanceIdentityDocument() (ec2metadata.EC2InstanceIdentityDocument, error) {
	return c.aws.EC2MGetInstanceIdentityDocument()
}
