package director

import (
	rpc "code.justin.tv/event-engineering/moonlight-api/pkg/rpc"
	controlRPC "code.justin.tv/event-engineering/moonlight-api/pkg/rpc/control"
	"code.justin.tv/event-engineering/moonlight-rtmp/pkg/rtmp"
	"context"
	"os"
)

func (s *director) handleEvents() {
	for {
		if s.stopped {
			return
		}
		select {
		case event, ok := <-s.events:
			if ok {
				go s.submitEvent(event)
			} else {
				return
			}
		}
	}
}

func (s *director) submitEvent(event rtmp.Event) {
	ctx := context.Background()

	// If it's the stream started event then register the internal listener Addr with the server
	// If it's the stream ended event then do the same but with a blank listen addr, for cleanliness
	if event.Type == rpc.RTMPEvent_StreamStarted || event.Type == rpc.RTMPEvent_StreamEnded || event.Type == rpc.RTMPEvent_StreamDisconnected {
		addr := ""

		if event.Type == rpc.RTMPEvent_StreamStarted {
			addr = s.rtmpServer.GetInternaRTMPAddr()
		}

		_, err := s.moonlightClient.RegisterStream(ctx, &controlRPC.RegisterStreamReq{
			RtmpKey:    event.StreamID,
			ListenAddr: addr,
		})

		if err != nil {
			s.logger.Warnf("Error registering Stream with RTMP Key: %v - %v", event.StreamID, err)
			return
		}
	}

	resp, err := s.moonlightClient.SubmitRTMPEvent(ctx, &controlRPC.SubmitRTMPEventReq{
		ServerId: s.ID,
		StreamId: event.StreamID,
		Event:    event.Type,
	})

	if err != nil {
		s.logger.Warnf("Error submitting RTMP event, %v", err)
	} else {
		s.logger.Debugf("Submitted event %v with ID %v", event.Type, resp.EventId)
	}

	// This feels real dirty, but it's gonna have to do for now
	if event.Type == rpc.RTMPEvent_StreamEnded || event.Type == rpc.RTMPEvent_StreamDisconnected {
		os.Exit(0)
	}
}
