package rtmp

import (
	"time"

	gortmp "code.justin.tv/event-engineering/gortmp/pkg/rtmp"
	internal "code.justin.tv/event-engineering/moonlight-api/pkg/rpc"
	"context"
)

const (
	// TODO, work out what these numbers should really be perhaps we should attempt to set these numbers dynamically
	streamBitrateBad = 200
	streamBitrateOK  = 500
)

func (s *rtmpServer) trackBitrate(ctx context.Context, ms gortmp.MediaStream, streamName string) {
	s.logger.Infof("start bitrate tracking")
	defer s.logger.Infof("end bitrate tracking")
	done := make(chan bool)
	go func() {
		ms.Wait()
		done <- true
	}()

	ticker := time.NewTicker(time.Second * 2)
	defer ticker.Stop()

	// This gets run at the start of the stream where the bitrate will be 0, so start in the "bad" state, and we will get a bitrate OK message when the data starts coming in
	bitrateIsBad := true

	for {
		select {
		case <-ticker.C:
			kBytesRate := float64(ms.Stats().VideoBytesRate) * 8 / 1024

			s.logger.Debugf("Current bitrate %v kbps", kBytesRate)
			if kBytesRate < streamBitrateBad && !bitrateIsBad {
				s.sendEvent(Event{
					StreamID: streamName,
					Type:     internal.RTMPEvent_StreamBitrateLow,
				})
				bitrateIsBad = true
			} else if kBytesRate > streamBitrateOK && bitrateIsBad {
				s.sendEvent(Event{
					StreamID: streamName,
					Type:     internal.RTMPEvent_StreamBitrateOK,
				})
				bitrateIsBad = false
			}
		case <-done:
			return
		}
	}
}
