package util

import (
	"net"
)

type ProxyConn struct {
	FDConn
	SrcAddr *net.TCPAddr
	DstAddr *net.TCPAddr
}

var _ FDConn = (*ProxyConn)(nil)
var _ net.Conn = (*ProxyConn)(nil)

func (pc *ProxyConn) RemoteAddr() net.Addr {
	if pc.SrcAddr != nil {
		return &proxyAddr{pc.SrcAddr, pc.DstAddr}
	}
	return pc.RemoteAddr()
}

type ProxyAddr interface {
	RemoteAddr() net.Addr
	ProxyAddr() net.Addr
}

type proxyAddr struct {
	net.Addr
	proxy net.Addr
}

func (pa *proxyAddr) RemoteAddr() net.Addr {
	return pa.Addr
}

func (pa *proxyAddr) ProxyAddr() net.Addr {
	return pa.proxy
}

func (pa *proxyAddr) Network() string {
	return pa.Addr.Network()
}

func (pa *proxyAddr) String() string {
	return pa.Addr.String()
}
