package util

import (
	"time"
)

type TimeoutConn struct {
	FDConn
	Timeout time.Duration
}

func (t *TimeoutConn) Read(b []byte) (int, error) {
	n, err := t.FDConn.Read(b)
	t.SetDeadline(time.Now().Add(t.Timeout))
	return n, err
}

func (t *TimeoutConn) Write(b []byte) (int, error) {
	n, err := t.FDConn.Write(b)
	t.SetDeadline(time.Now().Add(t.Timeout))
	return n, err
}
