package main

import (
	obs "code.justin.tv/event-engineering/obs-websocket-go/pkg/obs"
	"github.com/sirupsen/logrus"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.InfoLevel)

	client := obs.NewClient("127.0.0.1", 4444, logger)
	errCh, err := client.Go()

	if err != nil {
		panic(err)
	}

	go func() {
		rtErr := <-errCh
		if rtErr != nil {
			panic(rtErr)
		}
	}()

	resp, err := client.GetMute("RTMP")

	if err != nil {
		panic(err)
	}

	logger.Info(resp.Muted)
}
