package obs

import (
	"fmt"
	"strings"
)

type response interface {
	error() error
	messageID() string
}

type rawResponse struct {
	MessageID  string `json:"message-id"`
	UpdateType string `json:"update-type"`
	Status     string `json:"status"`
	Error      string `json:"error"`
}

func (r rawResponse) messageID() string {
	return r.MessageID
}

func (r rawResponse) error() error {
	if strings.ToLower(r.Status) == "ok" {
		return nil
	}
	return fmt.Errorf("obsws: status:%s error:%s", r.Status, r.Error)
}

type Source struct {
	Type   string  `json:"type"`
	Volume float64 `json:"volume"`
}

type Scene struct {
	Name    string   `json:"name"`
	Sources []Source `json:"sources"`
}

type GetSceneListResponse struct {
	CurrentScene string  `json:"current-scene"`
	Scenes       []Scene `json:"scenes"`
	rawResponse
}

type GetCurrentScene struct {
	Scene
	rawResponse
}

type GetStreamingStatusResponse struct {
	Streaming         bool   `json:"streaming"`
	Recording         bool   `json:"recording"`
	StreamTimecode    string `json:"stream-timecode"`
	RecordingTimecode string `json:"rec-timecode"`
	rawResponse
}

type GetMuteResponse struct {
	Name  string `json:"name"`
	Muted bool   `json:"muted"`
	rawResponse
}
