package api

import (
	"encoding/json"
	"net/http"
)

func SendResponse(writer http.ResponseWriter, statusCode int, body interface{}) error {
	writer.WriteHeader(statusCode)

	bytes, err := json.Marshal(body)
	if err != nil {
		return err
	}

	_, err = writer.Write(bytes)
	if err != nil {
		return err
	}

	return nil
}
