package modules

import (
	"net/http"

	"code.justin.tv/event-engineering/parsnip/app/modules/admin"
	"code.justin.tv/event-engineering/parsnip/app/modules/question"
	"code.justin.tv/event-engineering/parsnip/app/modules/video"
	parsnip "code.justin.tv/event-engineering/parsnip/pkg/rpc"
	"github.com/sirupsen/logrus"
	goji "goji.io"
	"goji.io/pat"
)

// AddModules will set up each module of the application, registering its paths
func AddModules(mux *goji.Mux, parsnipAPI parsnip.Parsnip, logger logrus.FieldLogger) {
	videoHandler := video.NewVideoHandler(parsnipAPI, logger)
	adminHandler := admin.NewAdminHandler(parsnipAPI, logger)
	questionHandler := question.NewQuestionHandler(parsnipAPI, logger)

	mux.Handle(pat.New("/video/*"), http.StripPrefix("/video", videoHandler))
	mux.Handle(pat.New("/admin/*"), http.StripPrefix("/admin", adminHandler))
	mux.Handle(pat.New("/question/*"), http.StripPrefix("/question", questionHandler))
}
