package video

import (
	"net/http"

	auth "code.justin.tv/event-engineering/parsnip/app/api/auth"
	"code.justin.tv/event-engineering/parsnip/app/util"
	parsnip "code.justin.tv/event-engineering/parsnip/pkg/rpc"
	"github.com/sirupsen/logrus"
	goji "goji.io"
	"goji.io/pat"
)

type handler struct {
	mux     *goji.Mux
	parsnip parsnip.Parsnip
	logger  logrus.FieldLogger
}

// NewVideoHandler will forward video API requests to the parsnip service
func NewVideoHandler(parsnipAPI parsnip.Parsnip, logger logrus.FieldLogger) http.Handler {
	handler := &handler{
		mux:     goji.NewMux(),
		logger:  logger,
		parsnip: parsnipAPI,
	}

	// Get Auth token
	handler.mux.HandleFunc(pat.Get("/channel-info/:channel_id"), handler.GetChannelInfo)

	return handler.mux
}

func (s *handler) GetChannelInfo(writer http.ResponseWriter, request *http.Request) {
	login := auth.GetUser(request.Context())
	channelID := pat.Param(request, "channel_id")

	// Login is determined by the API since we're passing the request context through
	s.logger.Debug("Calling GetChannelPageInfo with user %v", login)
	resp, err := s.parsnip.GetChannelPageInfo(request.Context(), &parsnip.GetChannelPageInfoRequest{
		ChannelId: channelID,
	})

	if err != nil {
		s.logger.WithError(err).Warn("Failed to get auth token for playback URL")
	}

	util.HandleResponse(writer, resp, err)
}
