#!/usr/bin/env node
import cdk = require('@aws-cdk/core');
import { ParsnipStack } from '../lib/parsnip-stack';

const app = new cdk.App();
new ParsnipStack(app, 'parsnip-ui-stg', {
  cdkProps: {
    stackName: 'parsnip-ui-stg',
    env: {
      account: '282758828945',
      region: 'us-west-2'
    }
  },
  cidr: '172.22.0.0/22',
  parsnipUIProps: {
    trivEAARN: 'arn:aws:execute-api:us-west-2:141456490005:86h2zuqgf2/live/*/*',
  },
  parsnipAPIProps: {
    // This is created OOB because CDK doesn't seem to support the creation of the type of key we need yet
    playbackAuthKeyParameterName: 'parsnip_playbackKey',
    adminBindleLockID: 'amzn1.bindle.resource.izwhaverzris5uuf5dsq',
    publisherBindleLockID: 'amzn1.bindle.resource.7czzncmhpnf7rbremdda',
    tokenExpirySeconds: 10,
    acao: 'https://parsnip-stg.video.xarth.tv',
    invokeFunctionRoles: [],
  },
});

new ParsnipStack(app, 'parsnip-ui-prod', {
  cdkProps: {
    stackName: 'parsnip-ui-prod',
    env: {
      account: '146308169381',
      region: 'us-west-2'
    },
    terminationProtection: true,
  },
  cidr: '172.22.4.0/22',
  parsnipUIProps: {
    trivEAARN: 'arn:aws:execute-api:us-west-2:141456490005:2i0k8cl899/live/*/*',
  },
  parsnipAPIProps: {
    // This is created OOB because CDK doesn't seem to support the creation of the type of key we need yet
    playbackAuthKeyParameterName: 'parsnip_playbackKey',
    adminBindleLockID: 'amzn1.bindle.resource.chce7sqqe45kvc6iuokq',
    publisherBindleLockID: 'amzn1.bindle.resource.av6fa7gjm4cy2n47wezq',
    tokenExpirySeconds: 10,
    acao: 'https://parsnip.video.xarth.tv',
    invokeFunctionRoles: [],
  },
});
