import cdk = require('@aws-cdk/core');
import app = require('./parsnip-ui/parsnip-ui');
import { ParsnipAPI, ParsnipAPIProps } from './parsnip-api/parsnip-api'
import * as ec2 from '@aws-cdk/aws-ec2';
import cm = require('./capacity-management/capacity-management');

export interface StackProps {
  cdkProps: cdk.StackProps;
  parsnipUIProps: app.ParsnipUIProps;
  parsnipAPIProps: ParsnipAPIProps;
  cidr: string
}

export class ParsnipStack extends cdk.Stack {
  Vpc: ec2.Vpc;

  constructor(scope: cdk.Construct, id: string, props: StackProps) {
    super(scope, id, props.cdkProps);

    this.Vpc = new ec2.Vpc(this, 'ParsnipVpc', {
      maxAzs: 3,
      cidr: props.cidr,
    })

    // API
    let api = new ParsnipAPI(this, 'ParsnipAPI', this.Vpc, props.parsnipAPIProps)

    // UI
    let ui = new app.ParsnipUI(this, 'ParsnipUI', this.Vpc, api.ServiceLambda, props.parsnipUIProps);

    // Let the UI call the API
    api.ServiceLambda.grantInvoke(ui.ParsnipUILambda)

    // Capacity management constructs from here https://git-aws.internal.justin.tv/coleiain/capacity-cdk but pulled in directly for now
    // Once CDK is stable I should probably add this to NPM
    new cm.CapacityCdk(this, "TwitchCapacityManagementRoles")
  }
}
