package main

import (
	"context"
	"encoding/json"
	"fmt"
	"time"

	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	parsnip "code.justin.tv/event-engineering/parsnip/pkg/rpc"
	"code.justin.tv/event-engineering/parsnip/pkg/svc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/ivs"
	"github.com/aws/aws-sdk-go/service/ssm"
	"github.com/sirupsen/logrus"
)

var (
	awsAccountID = "282758828945"
	isengardRole = "Admin"
	tokenExpiry  = time.Second * 10
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	channelsTableName := "parsnip-channels"
	questionsTableName := "parsnip-questions"
	playbackAuthKeyParameterName := "parsnip_playbackKey"

	credentials, err := credentials.GetIsengardCredentials(awsAccountID, isengardRole)

	if err != nil {
		logger.WithError(err).Fatal("Failed to generate credentials")
	}

	// Create am AWS session
	sess, err := session.NewSession(&aws.Config{
		Credentials: credentials,
		Region:      aws.String("us-west-2"),
	})

	if err != nil {
		panic(fmt.Errorf("Error creating AWS session %v", err))
	}

	ddbClient := dynamodb.New(sess)
	ivsClient := ivs.New(sess)
	ssmClient := ssm.New(sess)

	// Create the Service
	parsnipServer, err := svc.New(channelsTableName, questionsTableName, playbackAuthKeyParameterName, tokenExpiry, "*", ddbClient, ivsClient, ssmClient, nil, svc.BindleLockConfig{}, logger)

	if err != nil {
		panic(err)
	}

	doCreateChannel(parsnipServer)
}

func doCreateChannel(client svc.Client) {
	result, err := client.CreateChannel(context.Background(), &parsnip.CreateChannelRequest{
		ChannelId: "videoteam",
	})

	if err != nil {
		panic(err)
	}

	resp, err := client.UpdateChannel(context.Background(), &parsnip.UpdateChannelRequest{
		ChannelIdHash: result.ChannelIdHash,
		BindleLockId:  "amzn1.bindle.resource.d4nr3vzyk5fpanpjrdsq",
	})

	if err != nil {
		panic(err)
	}

	bytes, _ := json.MarshalIndent(resp, "", "  ")
	fmt.Println(string(bytes))
}
