// Code generated by protoc-gen-twirp v7.1.0, DO NOT EDIT.
// source: pkg/rpc/parsnip.proto

/*
Package Parsnip is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v7.1.0.

It is generated from these files:
	pkg/rpc/parsnip.proto
	pkg/rpc/question.proto
*/
package Parsnip

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import path "path"
import url "net/url"

// This is a compile-time assertion to ensure that this generated file
// is compatible with the twirp package used in your project.
// A compilation error at this line likely means your copy of the
// twirp package needs to be updated.
const _ = twirp.TwirpPackageIsVersion7

// =================
// Parsnip Interface
// =================

type Parsnip interface {
	GetModuleAccess(context.Context, *GetModuleAccessRequest) (*GetModuleAccessResponse, error)

	CreateChannel(context.Context, *CreateChannelRequest) (*ChannelInfo, error)

	UpdateChannel(context.Context, *UpdateChannelRequest) (*ChannelInfo, error)

	DeleteChannel(context.Context, *DeleteChannelRequest) (*DeleteChannelResponse, error)

	GetChannel(context.Context, *GetChannelRequest) (*ChannelInfo, error)

	ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error)

	GetChannelPageInfo(context.Context, *GetChannelPageInfoRequest) (*GetChannelPageInfoResponse, error)

	CreateQuestion(context.Context, *CreateQuestionRequest) (*Question, error)

	GetQuestion(context.Context, *GetQuestionRequest) (*Question, error)

	GetQuestions(context.Context, *GetQuestionsRequest) (*ListOf_Questions, error)

	UpvoteQuestion(context.Context, *UpvoteQuestionRequest) (*Question, error)

	DeleteQuestion(context.Context, *DeleteQuestionRequest) (*DeleteQuestionResponse, error)

	DeleteAllQuestions(context.Context, *DeleteAllQuestionsRequest) (*DeleteAllQuestionsResponse, error)

	AnswerQuestion(context.Context, *AnswerQuestionRequest) (*Question, error)
}

// =======================
// Parsnip Protobuf Client
// =======================

type parsnipProtobufClient struct {
	client      HTTPClient
	urls        [14]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewParsnipProtobufClient creates a Protobuf client that implements the Parsnip interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewParsnipProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Parsnip {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(clientOpts.PathPrefix(), "twitch.parsnip", "Parsnip")
	urls := [14]string{
		serviceURL + "GetModuleAccess",
		serviceURL + "CreateChannel",
		serviceURL + "UpdateChannel",
		serviceURL + "DeleteChannel",
		serviceURL + "GetChannel",
		serviceURL + "ListChannels",
		serviceURL + "GetChannelPageInfo",
		serviceURL + "CreateQuestion",
		serviceURL + "GetQuestion",
		serviceURL + "GetQuestions",
		serviceURL + "UpvoteQuestion",
		serviceURL + "DeleteQuestion",
		serviceURL + "DeleteAllQuestions",
		serviceURL + "AnswerQuestion",
	}

	return &parsnipProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *parsnipProtobufClient) GetModuleAccess(ctx context.Context, in *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetModuleAccess")
	caller := c.callGetModuleAccess
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetModuleAccessRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetModuleAccessRequest) when calling interceptor")
					}
					return c.callGetModuleAccess(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetModuleAccessResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetModuleAccessResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callGetModuleAccess(ctx context.Context, in *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
	out := new(GetModuleAccessResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) CreateChannel(ctx context.Context, in *CreateChannelRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannel")
	caller := c.callCreateChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateChannelRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateChannelRequest) when calling interceptor")
					}
					return c.callCreateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callCreateChannel(ctx context.Context, in *CreateChannelRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) UpdateChannel(ctx context.Context, in *UpdateChannelRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannel")
	caller := c.callUpdateChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateChannelRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateChannelRequest) when calling interceptor")
					}
					return c.callUpdateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callUpdateChannel(ctx context.Context, in *UpdateChannelRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) DeleteChannel(ctx context.Context, in *DeleteChannelRequest) (*DeleteChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	caller := c.callDeleteChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteChannelRequest) (*DeleteChannelResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteChannelRequest) when calling interceptor")
					}
					return c.callDeleteChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteChannelResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteChannelResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callDeleteChannel(ctx context.Context, in *DeleteChannelRequest) (*DeleteChannelResponse, error) {
	out := new(DeleteChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) GetChannel(ctx context.Context, in *GetChannelRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	caller := c.callGetChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelRequest) when calling interceptor")
					}
					return c.callGetChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callGetChannel(ctx context.Context, in *GetChannelRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) ListChannels(ctx context.Context, in *ListChannelsRequest) (*ListChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "ListChannels")
	caller := c.callListChannels
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListChannelsRequest) (*ListChannelsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListChannelsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListChannelsRequest) when calling interceptor")
					}
					return c.callListChannels(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListChannelsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListChannelsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callListChannels(ctx context.Context, in *ListChannelsRequest) (*ListChannelsResponse, error) {
	out := new(ListChannelsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) GetChannelPageInfo(ctx context.Context, in *GetChannelPageInfoRequest) (*GetChannelPageInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelPageInfo")
	caller := c.callGetChannelPageInfo
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelPageInfoRequest) (*GetChannelPageInfoResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelPageInfoRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelPageInfoRequest) when calling interceptor")
					}
					return c.callGetChannelPageInfo(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelPageInfoResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelPageInfoResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callGetChannelPageInfo(ctx context.Context, in *GetChannelPageInfoRequest) (*GetChannelPageInfoResponse, error) {
	out := new(GetChannelPageInfoResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) CreateQuestion(ctx context.Context, in *CreateQuestionRequest) (*Question, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "CreateQuestion")
	caller := c.callCreateQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateQuestionRequest) (*Question, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateQuestionRequest) when calling interceptor")
					}
					return c.callCreateQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callCreateQuestion(ctx context.Context, in *CreateQuestionRequest) (*Question, error) {
	out := new(Question)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) GetQuestion(ctx context.Context, in *GetQuestionRequest) (*Question, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetQuestion")
	caller := c.callGetQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetQuestionRequest) (*Question, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQuestionRequest) when calling interceptor")
					}
					return c.callGetQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callGetQuestion(ctx context.Context, in *GetQuestionRequest) (*Question, error) {
	out := new(Question)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) GetQuestions(ctx context.Context, in *GetQuestionsRequest) (*ListOf_Questions, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetQuestions")
	caller := c.callGetQuestions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetQuestionsRequest) (*ListOf_Questions, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQuestionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQuestionsRequest) when calling interceptor")
					}
					return c.callGetQuestions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListOf_Questions)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListOf_Questions) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callGetQuestions(ctx context.Context, in *GetQuestionsRequest) (*ListOf_Questions, error) {
	out := new(ListOf_Questions)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) UpvoteQuestion(ctx context.Context, in *UpvoteQuestionRequest) (*Question, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "UpvoteQuestion")
	caller := c.callUpvoteQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpvoteQuestionRequest) (*Question, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpvoteQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpvoteQuestionRequest) when calling interceptor")
					}
					return c.callUpvoteQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callUpvoteQuestion(ctx context.Context, in *UpvoteQuestionRequest) (*Question, error) {
	out := new(Question)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) DeleteQuestion(ctx context.Context, in *DeleteQuestionRequest) (*DeleteQuestionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteQuestion")
	caller := c.callDeleteQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteQuestionRequest) (*DeleteQuestionResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteQuestionRequest) when calling interceptor")
					}
					return c.callDeleteQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteQuestionResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteQuestionResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callDeleteQuestion(ctx context.Context, in *DeleteQuestionRequest) (*DeleteQuestionResponse, error) {
	out := new(DeleteQuestionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) DeleteAllQuestions(ctx context.Context, in *DeleteAllQuestionsRequest) (*DeleteAllQuestionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllQuestions")
	caller := c.callDeleteAllQuestions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteAllQuestionsRequest) (*DeleteAllQuestionsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteAllQuestionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteAllQuestionsRequest) when calling interceptor")
					}
					return c.callDeleteAllQuestions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteAllQuestionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteAllQuestionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callDeleteAllQuestions(ctx context.Context, in *DeleteAllQuestionsRequest) (*DeleteAllQuestionsResponse, error) {
	out := new(DeleteAllQuestionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipProtobufClient) AnswerQuestion(ctx context.Context, in *AnswerQuestionRequest) (*Question, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "AnswerQuestion")
	caller := c.callAnswerQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *AnswerQuestionRequest) (*Question, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AnswerQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AnswerQuestionRequest) when calling interceptor")
					}
					return c.callAnswerQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipProtobufClient) callAnswerQuestion(ctx context.Context, in *AnswerQuestionRequest) (*Question, error) {
	out := new(Question)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===================
// Parsnip JSON Client
// ===================

type parsnipJSONClient struct {
	client      HTTPClient
	urls        [14]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewParsnipJSONClient creates a JSON client that implements the Parsnip interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewParsnipJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) Parsnip {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(clientOpts.PathPrefix(), "twitch.parsnip", "Parsnip")
	urls := [14]string{
		serviceURL + "GetModuleAccess",
		serviceURL + "CreateChannel",
		serviceURL + "UpdateChannel",
		serviceURL + "DeleteChannel",
		serviceURL + "GetChannel",
		serviceURL + "ListChannels",
		serviceURL + "GetChannelPageInfo",
		serviceURL + "CreateQuestion",
		serviceURL + "GetQuestion",
		serviceURL + "GetQuestions",
		serviceURL + "UpvoteQuestion",
		serviceURL + "DeleteQuestion",
		serviceURL + "DeleteAllQuestions",
		serviceURL + "AnswerQuestion",
	}

	return &parsnipJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *parsnipJSONClient) GetModuleAccess(ctx context.Context, in *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetModuleAccess")
	caller := c.callGetModuleAccess
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetModuleAccessRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetModuleAccessRequest) when calling interceptor")
					}
					return c.callGetModuleAccess(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetModuleAccessResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetModuleAccessResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callGetModuleAccess(ctx context.Context, in *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
	out := new(GetModuleAccessResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) CreateChannel(ctx context.Context, in *CreateChannelRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannel")
	caller := c.callCreateChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateChannelRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateChannelRequest) when calling interceptor")
					}
					return c.callCreateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callCreateChannel(ctx context.Context, in *CreateChannelRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) UpdateChannel(ctx context.Context, in *UpdateChannelRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannel")
	caller := c.callUpdateChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateChannelRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateChannelRequest) when calling interceptor")
					}
					return c.callUpdateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callUpdateChannel(ctx context.Context, in *UpdateChannelRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) DeleteChannel(ctx context.Context, in *DeleteChannelRequest) (*DeleteChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	caller := c.callDeleteChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteChannelRequest) (*DeleteChannelResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteChannelRequest) when calling interceptor")
					}
					return c.callDeleteChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteChannelResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteChannelResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callDeleteChannel(ctx context.Context, in *DeleteChannelRequest) (*DeleteChannelResponse, error) {
	out := new(DeleteChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) GetChannel(ctx context.Context, in *GetChannelRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	caller := c.callGetChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelRequest) when calling interceptor")
					}
					return c.callGetChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callGetChannel(ctx context.Context, in *GetChannelRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) ListChannels(ctx context.Context, in *ListChannelsRequest) (*ListChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "ListChannels")
	caller := c.callListChannels
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListChannelsRequest) (*ListChannelsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListChannelsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListChannelsRequest) when calling interceptor")
					}
					return c.callListChannels(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListChannelsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListChannelsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callListChannels(ctx context.Context, in *ListChannelsRequest) (*ListChannelsResponse, error) {
	out := new(ListChannelsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) GetChannelPageInfo(ctx context.Context, in *GetChannelPageInfoRequest) (*GetChannelPageInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelPageInfo")
	caller := c.callGetChannelPageInfo
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelPageInfoRequest) (*GetChannelPageInfoResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelPageInfoRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelPageInfoRequest) when calling interceptor")
					}
					return c.callGetChannelPageInfo(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelPageInfoResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelPageInfoResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callGetChannelPageInfo(ctx context.Context, in *GetChannelPageInfoRequest) (*GetChannelPageInfoResponse, error) {
	out := new(GetChannelPageInfoResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) CreateQuestion(ctx context.Context, in *CreateQuestionRequest) (*Question, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "CreateQuestion")
	caller := c.callCreateQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateQuestionRequest) (*Question, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateQuestionRequest) when calling interceptor")
					}
					return c.callCreateQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callCreateQuestion(ctx context.Context, in *CreateQuestionRequest) (*Question, error) {
	out := new(Question)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) GetQuestion(ctx context.Context, in *GetQuestionRequest) (*Question, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetQuestion")
	caller := c.callGetQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetQuestionRequest) (*Question, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQuestionRequest) when calling interceptor")
					}
					return c.callGetQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callGetQuestion(ctx context.Context, in *GetQuestionRequest) (*Question, error) {
	out := new(Question)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) GetQuestions(ctx context.Context, in *GetQuestionsRequest) (*ListOf_Questions, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "GetQuestions")
	caller := c.callGetQuestions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetQuestionsRequest) (*ListOf_Questions, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQuestionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQuestionsRequest) when calling interceptor")
					}
					return c.callGetQuestions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListOf_Questions)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListOf_Questions) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callGetQuestions(ctx context.Context, in *GetQuestionsRequest) (*ListOf_Questions, error) {
	out := new(ListOf_Questions)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) UpvoteQuestion(ctx context.Context, in *UpvoteQuestionRequest) (*Question, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "UpvoteQuestion")
	caller := c.callUpvoteQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpvoteQuestionRequest) (*Question, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpvoteQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpvoteQuestionRequest) when calling interceptor")
					}
					return c.callUpvoteQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callUpvoteQuestion(ctx context.Context, in *UpvoteQuestionRequest) (*Question, error) {
	out := new(Question)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) DeleteQuestion(ctx context.Context, in *DeleteQuestionRequest) (*DeleteQuestionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteQuestion")
	caller := c.callDeleteQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteQuestionRequest) (*DeleteQuestionResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteQuestionRequest) when calling interceptor")
					}
					return c.callDeleteQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteQuestionResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteQuestionResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callDeleteQuestion(ctx context.Context, in *DeleteQuestionRequest) (*DeleteQuestionResponse, error) {
	out := new(DeleteQuestionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) DeleteAllQuestions(ctx context.Context, in *DeleteAllQuestionsRequest) (*DeleteAllQuestionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllQuestions")
	caller := c.callDeleteAllQuestions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteAllQuestionsRequest) (*DeleteAllQuestionsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteAllQuestionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteAllQuestionsRequest) when calling interceptor")
					}
					return c.callDeleteAllQuestions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteAllQuestionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteAllQuestionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callDeleteAllQuestions(ctx context.Context, in *DeleteAllQuestionsRequest) (*DeleteAllQuestionsResponse, error) {
	out := new(DeleteAllQuestionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *parsnipJSONClient) AnswerQuestion(ctx context.Context, in *AnswerQuestionRequest) (*Question, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithMethodName(ctx, "AnswerQuestion")
	caller := c.callAnswerQuestion
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *AnswerQuestionRequest) (*Question, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AnswerQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AnswerQuestionRequest) when calling interceptor")
					}
					return c.callAnswerQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *parsnipJSONClient) callAnswerQuestion(ctx context.Context, in *AnswerQuestionRequest) (*Question, error) {
	out := new(Question)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ======================
// Parsnip Server Handler
// ======================

type parsnipServer struct {
	Parsnip
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
}

// NewParsnipServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewParsnipServer(svc Parsnip, opts ...interface{}) TwirpServer {
	serverOpts := twirp.ServerOptions{}
	for _, opt := range opts {
		switch o := opt.(type) {
		case twirp.ServerOption:
			o(&serverOpts)
		case *twirp.ServerHooks: // backwards compatibility, allow to specify hooks as an argument
			twirp.WithServerHooks(o)(&serverOpts)
		case nil: // backwards compatibility, allow nil value for the argument
			continue
		default:
			panic(fmt.Sprintf("Invalid option type %T on NewParsnipServer", o))
		}
	}

	return &parsnipServer{
		Parsnip:          svc,
		pathPrefix:       serverOpts.PathPrefix(),
		interceptor:      twirp.ChainInterceptors(serverOpts.Interceptors...),
		hooks:            serverOpts.Hooks,
		jsonSkipDefaults: serverOpts.JSONSkipDefaults,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *parsnipServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ParsnipPathPrefix is a convenience constant that could used to identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// that add a "/twirp" prefix by default, and use CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const ParsnipPathPrefix = "/twirp/twitch.parsnip.Parsnip/"

func (s *parsnipServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.parsnip")
	ctx = ctxsetters.WithServiceName(ctx, "Parsnip")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "twitch.parsnip.Parsnip" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "GetModuleAccess":
		s.serveGetModuleAccess(ctx, resp, req)
		return
	case "CreateChannel":
		s.serveCreateChannel(ctx, resp, req)
		return
	case "UpdateChannel":
		s.serveUpdateChannel(ctx, resp, req)
		return
	case "DeleteChannel":
		s.serveDeleteChannel(ctx, resp, req)
		return
	case "GetChannel":
		s.serveGetChannel(ctx, resp, req)
		return
	case "ListChannels":
		s.serveListChannels(ctx, resp, req)
		return
	case "GetChannelPageInfo":
		s.serveGetChannelPageInfo(ctx, resp, req)
		return
	case "CreateQuestion":
		s.serveCreateQuestion(ctx, resp, req)
		return
	case "GetQuestion":
		s.serveGetQuestion(ctx, resp, req)
		return
	case "GetQuestions":
		s.serveGetQuestions(ctx, resp, req)
		return
	case "UpvoteQuestion":
		s.serveUpvoteQuestion(ctx, resp, req)
		return
	case "DeleteQuestion":
		s.serveDeleteQuestion(ctx, resp, req)
		return
	case "DeleteAllQuestions":
		s.serveDeleteAllQuestions(ctx, resp, req)
		return
	case "AnswerQuestion":
		s.serveAnswerQuestion(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *parsnipServer) serveGetModuleAccess(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetModuleAccessJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetModuleAccessProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveGetModuleAccessJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetModuleAccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetModuleAccessRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetModuleAccess
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetModuleAccessRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetModuleAccessRequest) when calling interceptor")
					}
					return s.Parsnip.GetModuleAccess(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetModuleAccessResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetModuleAccessResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetModuleAccessResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetModuleAccessResponse and nil error while calling GetModuleAccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveGetModuleAccessProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetModuleAccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetModuleAccessRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetModuleAccess
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetModuleAccessRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetModuleAccessRequest) when calling interceptor")
					}
					return s.Parsnip.GetModuleAccess(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetModuleAccessResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetModuleAccessResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetModuleAccessResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetModuleAccessResponse and nil error while calling GetModuleAccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveCreateChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveCreateChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.CreateChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateChannelRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateChannelRequest) when calling interceptor")
					}
					return s.Parsnip.CreateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling CreateChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveCreateChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.CreateChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateChannelRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateChannelRequest) when calling interceptor")
					}
					return s.Parsnip.CreateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling CreateChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveUpdateChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveUpdateChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.UpdateChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateChannelRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateChannelRequest) when calling interceptor")
					}
					return s.Parsnip.UpdateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling UpdateChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveUpdateChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.UpdateChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateChannelRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateChannelRequest) when calling interceptor")
					}
					return s.Parsnip.UpdateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling UpdateChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveDeleteChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveDeleteChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.DeleteChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteChannelRequest) (*DeleteChannelResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteChannelRequest) when calling interceptor")
					}
					return s.Parsnip.DeleteChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteChannelResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteChannelResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteChannelResponse and nil error while calling DeleteChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveDeleteChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.DeleteChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteChannelRequest) (*DeleteChannelResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteChannelRequest) when calling interceptor")
					}
					return s.Parsnip.DeleteChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteChannelResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteChannelResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteChannelResponse and nil error while calling DeleteChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveGetChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveGetChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelRequest) when calling interceptor")
					}
					return s.Parsnip.GetChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling GetChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveGetChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelRequest) when calling interceptor")
					}
					return s.Parsnip.GetChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling GetChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveListChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveListChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.ListChannels
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListChannelsRequest) (*ListChannelsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListChannelsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListChannelsRequest) when calling interceptor")
					}
					return s.Parsnip.ListChannels(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListChannelsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListChannelsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListChannelsResponse and nil error while calling ListChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveListChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.ListChannels
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListChannelsRequest) (*ListChannelsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListChannelsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListChannelsRequest) when calling interceptor")
					}
					return s.Parsnip.ListChannels(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListChannelsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListChannelsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListChannelsResponse and nil error while calling ListChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveGetChannelPageInfo(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelPageInfoJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelPageInfoProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveGetChannelPageInfoJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelPageInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelPageInfoRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetChannelPageInfo
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelPageInfoRequest) (*GetChannelPageInfoResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelPageInfoRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelPageInfoRequest) when calling interceptor")
					}
					return s.Parsnip.GetChannelPageInfo(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelPageInfoResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelPageInfoResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetChannelPageInfoResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelPageInfoResponse and nil error while calling GetChannelPageInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveGetChannelPageInfoProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelPageInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelPageInfoRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetChannelPageInfo
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelPageInfoRequest) (*GetChannelPageInfoResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelPageInfoRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelPageInfoRequest) when calling interceptor")
					}
					return s.Parsnip.GetChannelPageInfo(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelPageInfoResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelPageInfoResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetChannelPageInfoResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelPageInfoResponse and nil error while calling GetChannelPageInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveCreateQuestion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateQuestionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateQuestionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveCreateQuestionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateQuestionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.CreateQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateQuestionRequest) (*Question, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.CreateQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Question
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Question and nil error while calling CreateQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveCreateQuestionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateQuestionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.CreateQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateQuestionRequest) (*Question, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.CreateQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Question
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Question and nil error while calling CreateQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveGetQuestion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetQuestionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetQuestionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveGetQuestionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetQuestionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetQuestionRequest) (*Question, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.GetQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Question
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Question and nil error while calling GetQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveGetQuestionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetQuestionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetQuestionRequest) (*Question, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.GetQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Question
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Question and nil error while calling GetQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveGetQuestions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetQuestionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetQuestionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveGetQuestionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetQuestions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetQuestionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetQuestions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetQuestionsRequest) (*ListOf_Questions, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQuestionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQuestionsRequest) when calling interceptor")
					}
					return s.Parsnip.GetQuestions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListOf_Questions)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListOf_Questions) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListOf_Questions
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Questions and nil error while calling GetQuestions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveGetQuestionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetQuestions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetQuestionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.GetQuestions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetQuestionsRequest) (*ListOf_Questions, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQuestionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQuestionsRequest) when calling interceptor")
					}
					return s.Parsnip.GetQuestions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListOf_Questions)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListOf_Questions) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListOf_Questions
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListOf_Questions and nil error while calling GetQuestions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveUpvoteQuestion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpvoteQuestionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpvoteQuestionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveUpvoteQuestionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpvoteQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpvoteQuestionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.UpvoteQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpvoteQuestionRequest) (*Question, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpvoteQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpvoteQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.UpvoteQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Question
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Question and nil error while calling UpvoteQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveUpvoteQuestionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpvoteQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpvoteQuestionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.UpvoteQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpvoteQuestionRequest) (*Question, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpvoteQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpvoteQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.UpvoteQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Question
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Question and nil error while calling UpvoteQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveDeleteQuestion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteQuestionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteQuestionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveDeleteQuestionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteQuestionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.DeleteQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteQuestionRequest) (*DeleteQuestionResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.DeleteQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteQuestionResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteQuestionResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteQuestionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteQuestionResponse and nil error while calling DeleteQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveDeleteQuestionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteQuestionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.DeleteQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteQuestionRequest) (*DeleteQuestionResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.DeleteQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteQuestionResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteQuestionResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteQuestionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteQuestionResponse and nil error while calling DeleteQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveDeleteAllQuestions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteAllQuestionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteAllQuestionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveDeleteAllQuestionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllQuestions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteAllQuestionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.DeleteAllQuestions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteAllQuestionsRequest) (*DeleteAllQuestionsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteAllQuestionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteAllQuestionsRequest) when calling interceptor")
					}
					return s.Parsnip.DeleteAllQuestions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteAllQuestionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteAllQuestionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteAllQuestionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAllQuestionsResponse and nil error while calling DeleteAllQuestions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveDeleteAllQuestionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteAllQuestions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteAllQuestionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.DeleteAllQuestions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteAllQuestionsRequest) (*DeleteAllQuestionsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteAllQuestionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteAllQuestionsRequest) when calling interceptor")
					}
					return s.Parsnip.DeleteAllQuestions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*DeleteAllQuestionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*DeleteAllQuestionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *DeleteAllQuestionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteAllQuestionsResponse and nil error while calling DeleteAllQuestions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveAnswerQuestion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAnswerQuestionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAnswerQuestionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *parsnipServer) serveAnswerQuestionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AnswerQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AnswerQuestionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	handler := s.Parsnip.AnswerQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *AnswerQuestionRequest) (*Question, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AnswerQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AnswerQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.AnswerQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Question
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Question and nil error while calling AnswerQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true, EmitDefaults: !s.jsonSkipDefaults}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) serveAnswerQuestionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AnswerQuestion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AnswerQuestionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.Parsnip.AnswerQuestion
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *AnswerQuestionRequest) (*Question, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AnswerQuestionRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AnswerQuestionRequest) when calling interceptor")
					}
					return s.Parsnip.AnswerQuestion(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Question)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Question) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Question
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Question and nil error while calling AnswerQuestion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *parsnipServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *parsnipServer) ProtocGenTwirpVersion() string {
	return "v7.1.0"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *parsnipServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "twitch.parsnip", "Parsnip")
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler

	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)

	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string

	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route Twirp requests.
	// The path prefix is in the form: "/<prefix>/<package>.<Service>/"
	// that is, everything in a Twirp route except for the <Method> at the end.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// sanitizeBaseURL parses the the baseURL, and adds the "http" scheme if needed.
// If the URL is unparsable, the baseURL is returned unchaged.
func sanitizeBaseURL(baseURL string) string {
	u, err := url.Parse(baseURL)
	if err != nil {
		return baseURL // invalid URL will fail later when making requests
	}
	if u.Scheme == "" {
		u.Scheme = "http"
	}
	return u.String()
}

// baseServicePath composes the path prefix for the service (without <Method>).
// e.g.: baseServicePath("/twirp", "my.pkg", "MyService")
//       returns => "/twirp/my.pkg.MyService/"
// e.g.: baseServicePath("", "", "MyService")
//       returns => "/MyService/"
func baseServicePath(prefix, pkg, service string) string {
	fullServiceName := service
	if pkg != "" {
		fullServiceName = pkg + "." + service
	}
	return path.Join("/", prefix, fullServiceName) + "/"
}

// parseTwirpPath extracts path components form a valid Twirp route.
// Expected format: "[<prefix>]/<package>.<Service>/<Method>"
// e.g.: prefix, pkgService, method := parseTwirpPath("/twirp/pkg.Svc/MakeHat")
func parseTwirpPath(path string) (string, string, string) {
	parts := strings.Split(path, "/")
	if len(parts) < 2 {
		return "", "", ""
	}
	method := parts[len(parts)-1]
	pkgService := parts[len(parts)-2]
	prefix := strings.Join(parts[0:len(parts)-2], "/")
	return prefix, pkgService, method
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v7.1.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429: // Too Many Requests
			code = twirp.ResourceExhausted
		case 502, 503, 504: // Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 772 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xdb, 0x4e, 0xdb, 0x4a,
	0x14, 0x55, 0x12, 0x0e, 0x24, 0x3b, 0x21, 0x9c, 0x33, 0x04, 0x30, 0x39, 0x42, 0x02, 0x73, 0x29,
	0xf4, 0x21, 0x48, 0xf4, 0xa1, 0x52, 0x2b, 0x55, 0x4a, 0x41, 0xa2, 0x11, 0x54, 0x84, 0x94, 0xa8,
	0x6a, 0x55, 0xc9, 0x72, 0xec, 0x81, 0x8c, 0x6c, 0x6c, 0xd7, 0x33, 0x09, 0xe2, 0x1b, 0xfa, 0x3b,
	0x7d, 0xea, 0x47, 0xf5, 0xa9, 0x1f, 0x50, 0x8d, 0x3d, 0x8e, 0x63, 0x7b, 0x72, 0x29, 0x52, 0x1f,
	0xbd, 0xf7, 0x9a, 0xb5, 0xd7, 0xbe, 0x26, 0xb0, 0xe6, 0x59, 0x77, 0xc7, 0xbe, 0x67, 0x1c, 0x7b,
	0xba, 0x4f, 0x1d, 0xe2, 0x35, 0x3c, 0xdf, 0x65, 0x2e, 0xaa, 0xb2, 0x07, 0xc2, 0x8c, 0x7e, 0x43,
	0x58, 0xeb, 0xeb, 0x11, 0xec, 0xeb, 0x00, 0x53, 0x46, 0x5c, 0x27, 0xc4, 0xa9, 0x3f, 0xf3, 0x50,
	0x3e, 0xed, 0xeb, 0x8e, 0x83, 0xed, 0x96, 0x73, 0xeb, 0xa2, 0x03, 0x58, 0x31, 0xc2, 0x4f, 0x8d,
	0x98, 0x5a, 0x5f, 0xa7, 0x7d, 0x25, 0xb7, 0x9d, 0x3b, 0x2c, 0x75, 0x96, 0x85, 0xb9, 0x65, 0xbe,
	0xd3, 0x69, 0x1f, 0x6d, 0x01, 0xc4, 0x38, 0x25, 0x1f, 0x40, 0x4a, 0x23, 0x08, 0xda, 0x83, 0x6a,
	0x8f, 0x38, 0xa6, 0x8d, 0x35, 0xdb, 0x35, 0x2c, 0x0e, 0x29, 0x04, 0x90, 0x4a, 0x68, 0xbd, 0x74,
	0x0d, 0xab, 0x65, 0xf2, 0x60, 0x64, 0x48, 0xb5, 0x88, 0x48, 0xf7, 0x1d, 0x65, 0x21, 0x0c, 0x46,
	0x86, 0x54, 0xa8, 0x6a, 0xfa, 0x0e, 0x3a, 0x84, 0x7f, 0x39, 0xce, 0xb3, 0xf5, 0xc7, 0x9e, 0x6e,
	0x58, 0xda, 0xc0, 0xb7, 0x95, 0x7f, 0x02, 0x60, 0x95, 0x0c, 0x69, 0x5b, 0x98, 0xbb, 0xbe, 0xcd,
	0xe3, 0x72, 0x24, 0x65, 0x3e, 0xd6, 0xef, 0x35, 0x0b, 0x3f, 0x2a, 0x8b, 0x61, 0x5c, 0x32, 0xa4,
	0x1f, 0x02, 0xe3, 0x05, 0x7e, 0x8c, 0x50, 0xc4, 0xb9, 0xc3, 0x94, 0x05, 0x6c, 0x4b, 0x23, 0x54,
	0x2b, 0x30, 0x72, 0xae, 0x5d, 0x88, 0x72, 0xd6, 0x18, 0x61, 0x36, 0x56, 0x8a, 0x21, 0x48, 0x18,
	0x6f, 0xb8, 0x0d, 0x1d, 0xc3, 0x6a, 0x04, 0x32, 0x31, 0x35, 0x7c, 0xe2, 0xf1, 0xe2, 0x2a, 0xa5,
	0x00, 0x8a, 0x84, 0xeb, 0x2c, 0xf6, 0xa8, 0xdf, 0x72, 0x50, 0x3b, 0xf5, 0xb1, 0xce, 0xb0, 0x48,
	0xb0, 0x83, 0x83, 0x96, 0xa4, 0x2a, 0x9a, 0x4b, 0x57, 0x34, 0xa3, 0x26, 0x3f, 0xbf, 0x9a, 0xc2,
	0x44, 0x35, 0x3f, 0x72, 0x50, 0xeb, 0x7a, 0x66, 0x56, 0xcd, 0xbc, 0x73, 0x90, 0x6d, 0x74, 0x5e,
	0xd2, 0xe8, 0x8c, 0xf8, 0xc2, 0xfc, 0xe2, 0x17, 0x26, 0x8a, 0x7f, 0x03, 0xb5, 0x33, 0x6c, 0xe3,
	0xa7, 0x6a, 0x57, 0x37, 0x60, 0x2d, 0xf5, 0x9e, 0x7a, 0xae, 0x43, 0xb1, 0xfa, 0x1a, 0xfe, 0x3b,
	0xc7, 0xec, 0x89, 0xac, 0xaf, 0x60, 0x33, 0x7e, 0xdc, 0xd6, 0xef, 0x30, 0xdf, 0xab, 0xf9, 0x9a,
	0xac, 0x7e, 0xcf, 0x41, 0x5d, 0xf6, 0x38, 0xd4, 0x85, 0x76, 0xa0, 0x92, 0xd8, 0x81, 0xf0, 0x7d,
	0xd9, 0x1b, 0x5b, 0x80, 0x2d, 0x00, 0x7d, 0xc0, 0xfa, 0x1a, 0x73, 0x2d, 0xec, 0x44, 0x7b, 0xc9,
	0x2d, 0x37, 0xdc, 0xf0, 0x97, 0x1a, 0xa1, 0xc0, 0xfa, 0x39, 0x66, 0xef, 0x5d, 0x73, 0x60, 0xe3,
	0xa6, 0x61, 0x60, 0x4a, 0x45, 0xbe, 0xea, 0x47, 0xd8, 0xc8, 0x78, 0x44, 0x32, 0x9b, 0x50, 0x24,
	0x54, 0xd3, 0xcd, 0x7b, 0xe2, 0x04, 0x89, 0x14, 0x3b, 0x4b, 0x84, 0x36, 0xf9, 0x27, 0xcf, 0x93,
	0x50, 0xcd, 0x1b, 0xf4, 0x6c, 0x42, 0xfb, 0xd8, 0x0f, 0xd2, 0x28, 0x76, 0xca, 0x84, 0xb6, 0x23,
	0x93, 0xba, 0x06, 0xab, 0x97, 0x84, 0x46, 0x95, 0x1a, 0xc5, 0xbb, 0x82, 0x5a, 0xd2, 0x2c, 0x82,
	0xbd, 0x84, 0xa2, 0xd0, 0x4d, 0x95, 0xdc, 0x76, 0xe1, 0xb0, 0x7c, 0xf2, 0x7f, 0x23, 0x79, 0x21,
	0x1b, 0x63, 0x57, 0xb0, 0x33, 0x02, 0x9f, 0xfc, 0x2a, 0xc1, 0x52, 0x3b, 0x44, 0xa0, 0x1e, 0xac,
	0xa4, 0x92, 0x41, 0x07, 0x69, 0x16, 0x79, 0x1d, 0xea, 0xcf, 0x66, 0xe2, 0x84, 0xd0, 0x0e, 0x2c,
	0x27, 0xae, 0x03, 0xda, 0xcb, 0xe8, 0x94, 0x1c, 0x8f, 0xfa, 0xb4, 0x6c, 0x38, 0x67, 0x62, 0xc7,
	0xb3, 0x9c, 0xb2, 0x13, 0x30, 0x9d, 0xf3, 0x0b, 0x2c, 0x27, 0x76, 0x27, 0xcb, 0x29, 0x5b, 0xcd,
	0xfa, 0xfe, 0x0c, 0x94, 0xa8, 0xc2, 0x25, 0x40, 0xbc, 0x06, 0x68, 0x47, 0x52, 0xbc, 0x3f, 0xd1,
	0xfa, 0x09, 0x2a, 0xe3, 0x43, 0x81, 0x76, 0xd3, 0x60, 0xc9, 0x24, 0xd5, 0xf7, 0xa6, 0x83, 0x84,
	0x50, 0x0b, 0x50, 0x76, 0x5f, 0xd1, 0xd1, 0x64, 0xc1, 0xa9, 0x83, 0x50, 0x7f, 0x3e, 0x0f, 0x54,
	0x04, 0xbb, 0x86, 0x6a, 0xd8, 0xfc, 0x6b, 0xf1, 0x1b, 0x8e, 0xf6, 0xe5, 0xc3, 0x11, 0xf9, 0xa3,
	0x20, 0x4a, 0x1a, 0x36, 0x22, 0xb8, 0x80, 0xf2, 0x39, 0x66, 0xa3, 0x4f, 0x55, 0xa2, 0x66, 0x7e,
	0xb2, 0x2e, 0x54, 0xc6, 0xf0, 0x92, 0x3a, 0x8f, 0x7b, 0x23, 0xba, 0x6d, 0x59, 0x9d, 0xaf, 0x6e,
	0xb5, 0x98, 0xe6, 0x1a, 0xaa, 0x5d, 0x6f, 0xe8, 0x4e, 0x4b, 0x3b, 0xe9, 0x9f, 0xad, 0x54, 0x83,
	0x6a, 0x38, 0x78, 0x93, 0x29, 0x93, 0xfe, 0x88, 0xf2, 0x60, 0x16, 0x2c, 0x9e, 0x8b, 0xd0, 0xd3,
	0xb4, 0xed, 0x38, 0x93, 0x23, 0xf9, 0xeb, 0x71, 0xcc, 0xc4, 0xb9, 0x90, 0x41, 0xe3, 0xb9, 0x68,
	0x3a, 0xf4, 0x01, 0xfb, 0x93, 0xb3, 0x49, 0xfa, 0x67, 0x16, 0xe8, 0x6d, 0xe9, 0x73, 0x74, 0xf5,
	0x7a, 0x8b, 0xc1, 0x1f, 0xc5, 0x17, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0x4a, 0x13, 0xed, 0xa8,
	0x69, 0x0a, 0x00, 0x00,
}
