package svc

import "context"

type key int

const (
	keyUserID key = iota
)

const UserIDHeader = "parsnip-user-id"

// WithUserID will add the supplied userID to the context
func WithUserID(ctx context.Context, userID string) context.Context {
	return context.WithValue(ctx, keyUserID, userID)
}

func UserID(ctx context.Context) string {
	userID, ok := ctx.Value(keyUserID).(string)
	if !ok {
		return ""
	}
	return userID
}
