package svc

import (
	"context"

	parsnip "code.justin.tv/event-engineering/parsnip/pkg/rpc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
	"github.com/twitchtv/twirp"
)

func (c *client) ListChannels(ctx context.Context, request *parsnip.ListChannelsRequest) (*parsnip.ListChannelsResponse, error) {
	isAdmin, isPublisher, err := c.getPermissions(ctx)
	if err != nil {
		c.logger.WithError(err).Warn("Failed to establish permissions")
		return nil, err
	}

	if !isAdmin && !isPublisher {
		return nil, twirp.NewError(twirp.PermissionDenied, "You do not have permission to perform this action")
	}

	resp, err := c.ddb.Scan(&dynamodb.ScanInput{
		TableName: aws.String(c.channelsTableName),
	})

	if err != nil {
		return nil, err
	}

	var channels []*ddbChannel

	err = dynamodbattribute.UnmarshalListOfMaps(resp.Items, &channels)

	if err != nil {
		return nil, err
	}

	result := &parsnip.ListChannelsResponse{
		Channels: make([]*parsnip.ChannelInfo, 0, len(channels)),
	}

	for _, ch := range channels {
		result.Channels = append(result.Channels, &parsnip.ChannelInfo{
			ChannelIdHash: ch.ChannelIDHash,
			ChannelId:     ch.ChannelID,
			IvsChannelArn: ch.IVSChannelARN,
		})
	}

	return result, nil
}
