import React from "react";
import {
  AlignItems,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  LayoutProps,
} from "twitch-core-ui";

interface Props extends LayoutProps {}

export const Centered: React.FC<Props> = (props) => (
  <Layout
    display={Display.Flex}
    flexDirection={FlexDirection.Column}
    justifyContent={JustifyContent.Center}
    alignItems={AlignItems.Center}
    fullHeight
    fullWidth
    {...props}
  >
    {props.children}
  </Layout>
);
