import * as React from "react";
import { ThemeToggle } from "twitch-core-ui";

interface Props {}

interface State {
  currentValue: boolean;
}

export class PageThemeToggle extends React.Component<Props, State> {
  public state = {
    currentValue: false,
  };

  public componentDidMount() {
    const defaultValue =
      "tw-root--theme-dark" === localStorage.getItem("currentThemeValue");
    this.setTheme(defaultValue);
    this.setState({
      currentValue: defaultValue,
    });
  }

  public render() {
    return (
      <ThemeToggle
        checked={this.state.currentValue}
        onChange={this.handleChange}
      />
    );
  }

  private handleChange = (e: React.FormEvent<HTMLInputElement>) => {
    this.setTheme(e.currentTarget.checked);
    this.setState({ currentValue: e.currentTarget.checked });
  };

  private setTheme(checked: boolean) {
    const wrapper = document.querySelector("html");
    if (!wrapper) {
      return;
    }

    if (checked) {
      wrapper.classList.remove("tw-root--theme-light");
      wrapper.classList.add("tw-root--theme-dark");
      localStorage.setItem("currentThemeValue", "tw-root--theme-dark");
    } else {
      wrapper.classList.remove("tw-root--theme-dark");
      wrapper.classList.add("tw-root--theme-light");
      localStorage.setItem("currentThemeValue", "tw-root--theme-light");
    }
  }
}
