import React from "react";
import { Layout } from "twitch-core-ui";
import { QuestionsBody } from "./questions-body";
import { QuestionsHeader } from "./questions-header";
import { UserInfo } from "../../App";

export interface Props {
  channelID: string,
  userInfo: UserInfo | null;
}

export interface State {
}

export class Questions extends React.Component<Props, State> {
  constructor(props) {
    super(props);

    this.state = {
    };
  }

  public render() {
    return (
      <Layout>
        <QuestionsHeader channelID={this.props.channelID} />
        <QuestionsBody channelID={this.props.channelID} hideInput={false} userInfo={this.props.userInfo} />
      </Layout>
    );
  }
}
