import * as React from "react";
import {
  CoreText,
  Layout,
  TextAlign,
  TextType,
  Display,
  Table,
  TableBody,
  AlignSelf,
  TableCell,
  Button,
  SVGAsset,
  TableHeader,
  TableHeading,
  TableRow,
} from "twitch-core-ui";
import { getChannelList, ChannelInfo } from "../../api/api";
import { APIError } from "../../lib/api";
import { Link } from "react-router-dom";

interface State {
  channels?: ChannelInfo[];
  errorMessage: string;
  processing: boolean;
}

export class AdminHomePage extends React.Component<{}, State> {
  public state: State = {
    processing: true,
    errorMessage: "",
    channels: [],
  };

  public render() {
    if (this.state.errorMessage) {
      return (
        <Layout
          display={Display.Block}
          textAlign={TextAlign.Center}
          padding={4}
        >
          <CoreText type={TextType.H3}>{this.state.errorMessage}</CoreText>
        </Layout>
      );
    }

    let list = <></>;

    if (this.state && this.state.channels) {
      list = (
        <TableBody>
          {this.state.channels.map((channel, index) => (
            <TableRow key={index}>
              <TableCell>{channel.channel_id}</TableCell>
              <TableCell>{channel.ivs_channel_arn}</TableCell>
              <TableCell>
                <Link to={"/admin/channel/" + channel.channel_id_hash}>
                  Details
                </Link>
              </TableCell>
            </TableRow>
          ))}
        </TableBody>
      );
    }

    return (
      <Layout
        className="screen-optim-layout"
        fullWidth
        fullHeight
        padding={4}
        margin={{ x: "auto" }}
      >
        <Layout textAlign={TextAlign.Left}>
          <Layout display={Display.Flex}>
            <Layout flexGrow={1}>
              <CoreText type={TextType.H3}>Channels</CoreText>
            </Layout>
            <Layout flexGrow={0} alignSelf={AlignSelf.End}>
              <Button icon={SVGAsset.Plus} linkTo="/admin/channel/new">
                Create Channel
              </Button>
            </Layout>
          </Layout>
          <Layout margin={{ top: 2 }}>
            <Table>
              <TableHeader>
                <TableHeading label="Channel ID" />
                <TableHeading label="IVS Channel Arn" />
                <TableHeading label="Details" />
              </TableHeader>
              {list}
            </Table>
          </Layout>
        </Layout>
      </Layout>
    );
  }

  public componentDidMount() {
    this.setState({
      processing: true,
    });

    this.getChannels();
  }

  private async getChannels() {
    await getChannelList().then(
      (channels) => {
        this.setState({
          channels,
          processing: false,
        });
      },
      (reason: APIError) => {
        this.setState({
          errorMessage: reason.message,
          processing: false,
        });
      }
    );
  }
}
