import * as React from "react";
import {
  AlignItems,
  Background,
  Color,
  CoreButton,
  CoreButtonLabel,
  CoreButtonSize,
  CoreButtonType,
  CoreLink,
  CoreText,
  Display,
  FontSize,
  InjectLayout,
  Input,
  InputSize,
  InputType,
  JustifyContent,
  Layout,
  Title,
} from "twitch-core-ui";

export interface HomePageState {
  joinChannelValue: String;
}

export class HomePage extends React.Component<{}, HomePageState> {
  public render() {
    return (
      <Layout
        fullWidth
        fullHeight
        padding={{ x: 2 }}
        display={Display.Flex}
        alignItems={AlignItems.Center}
        justifyContent={JustifyContent.Center}
      >
        <Layout
          className="text-optim-layout"
          background={Background.Alt2}
          fullWidth
          padding={{ x: 4, y: 5 }}
        >
          <InjectLayout margin={{ bottom: 2 }}>
            <Title>Join a Channel</Title>
          </InjectLayout>
          <Layout margin={{ bottom: 1 }} display={Display.Flex} fullWidth>
            {/* Need an extra layout here to fix input width when the parent is not display: block */}
            <Layout margin={{ right: 1 }} fullWidth>
              <Input
                type={InputType.Text}
                size={InputSize.Large}
                placeholder="Channel ID"
                id="join-a-channel"
                aria-label="Join a Channel"
                value={`${this.state.joinChannelValue}`}
                onKeyDown={this.handleJoinChannelKeyDown}
                onChange={this.handleJoinChannelChange}
                autoFocus
              />
            </Layout>
            <Layout>
              {/* Need an extra layout here to fix padding collapse issues */}
              <CoreButton
                type={CoreButtonType.Primary}
                size={CoreButtonSize.Large}
                onClick={this.handleJoinChannelClick}
              >
                <CoreButtonLabel>Join Channel</CoreButtonLabel>
              </CoreButton>
            </Layout>
          </Layout>
          <CoreText sizes={FontSize.Size7} color={Color.Alt2}>
            For example: <CoreLink linkTo="/allhands">allhands</CoreLink>
          </CoreText>
        </Layout>
      </Layout>
    );
  }

  public constructor(props) {
    super(props);
    this.state = {
      joinChannelValue: "",
    };
    this.navigateToChannelID = this.navigateToChannelID.bind(this);
    this.setJoinChannelValue = this.setJoinChannelValue.bind(this);
    this.handleJoinChannelChange = this.handleJoinChannelChange.bind(this);
    this.handleJoinChannelKeyDown = this.handleJoinChannelKeyDown.bind(this);
    this.handleJoinChannelClick = this.handleJoinChannelClick.bind(this);
  }

  private navigateToChannelID(id) {
    const baseUrl = window.location.origin;
    window.location.href = `${baseUrl}/${id}`;
  }

  private setJoinChannelValue(value) {
    console.log(value);
    this.setState({
      joinChannelValue: value,
    });
  }

  private handleJoinChannelChange(e) {
    this.setJoinChannelValue(e.target.value);
  }

  private handleJoinChannelKeyDown(e) {
    if (e.key === "Enter") {
      this.navigateToChannelID(this.state.joinChannelValue);
    }
  }

  private handleJoinChannelClick(e) {
    this.navigateToChannelID(this.state.joinChannelValue);
  }
}
