/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: MIT-0
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this
 * software and associated documentation files (the "Software"), to deal in the Software
 * without restriction, including without limitation the rights to use, copy, modify,
 * merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

// Configuration
const playbackUrl =
  "https://a331037e445e.us-west-2.playback.live-video.net/api/video/v1/us-west-2.572018738257.channel.06pJXRPaYpwc.m3u8";
const endpoints = {
  clip: `https://7b49b6favg.execute-api.us-west-2.amazonaws.com/default/gdm?channel=${playbackUrl}`
};

// Elements
const playerOverlay = document.getElementById("overlay");
const playerControls = document.getElementById("player-controls");
const btnPlay = document.getElementById("play");
const btnMute = document.getElementById("mute");
const btnClip = document.getElementById("clip");
const btnSettings = document.getElementById("settings");
const settingsMenu = document.getElementById("settings-menu");
const clipPlayer = document.getElementById("clip_player");
const closeClip = document.getElementById("clip_close");

// App
const videoPlayer = document.getElementById("video-player");
const clientId = `${Math.random()
  .toString()
  .slice(2)}${Math.random().toString().slice(2)}`;

(function (IVSPlayer) {
  const PlayerState = IVSPlayer.PlayerState;
  const PlayerEventType = IVSPlayer.PlayerEventType;

  // Initialize player
  const player = IVSPlayer.create();
  player.attachHTMLVideoElement(videoPlayer);

  player.addEventListener(PlayerEventType.TEXT_METADATA_CUE, function (cue) {
    const metadataText = cue.text;
    const position = player.getPosition().toFixed(2);
    console.log(
      `Player Event - TEXT_METADATA_CUE: "${metadataText}". Observed ${position}s after playback started.`
    );
  });

  // Setup stream and play
  player.setAutoplay(true);
  player.load(playbackUrl);
  player.setVolume(0);

  // Show/Hide player controls
  playerOverlay.addEventListener(
    "mouseover",
    function (e) {
      playerOverlay.classList.add("player--hover");
    },
    false
  );
  playerOverlay.addEventListener("mouseout", function (e) {
    playerOverlay.classList.remove("player--hover");
  });

  // Controls events
  // Play/Pause
  btnPlay.addEventListener(
    "click",
    function (e) {
      if (btnPlay.classList.contains("btn--play")) {
        // change to pause
        btnPlay.classList.remove("btn--play");
        btnPlay.classList.add("btn--pause");
        player.pause();
      } else {
        // change to play
        btnPlay.classList.remove("btn--pause");
        btnPlay.classList.add("btn--play");
        player.play();
      }
    },
    false
  );

  // Mute/Unmute
  btnMute.addEventListener(
    "click",
    function (e) {
      if (btnMute.classList.contains("btn--mute")) {
        btnMute.classList.remove("btn--mute");
        btnMute.classList.add("btn--unmute");
        player.setMuted(1);
      } else {
        btnMute.classList.remove("btn--unmute");
        btnMute.classList.add("btn--mute");
        player.setMuted(0);
      }
    },
    false
  );

  // Create Quality Options
  let createQualityOptions = function (obj, i) {
    let q = document.createElement("a");
    let qText = document.createTextNode(obj.name);
    settingsMenu.appendChild(q);
    q.classList.add("settings-menu-item");
    q.appendChild(qText);

    q.addEventListener("click", (event) => {
      player.setQuality(obj);
      return false;
    });
  };

  // Close Settings menu
  let closeSettingsMenu = function () {
    btnSettings.classList.remove("btn--settings-on");
    btnSettings.classList.add("btn--settings-off");
    settingsMenu.classList.remove("open");
  };

  // Settings
  btnSettings.addEventListener(
    "click",
    function (e) {
      let qualities = player.getQualities();
      let currentQuality = player.getQuality();

      // Empty Settings menu
      while (settingsMenu.firstChild)
        settingsMenu.removeChild(settingsMenu.firstChild);

      if (btnSettings.classList.contains("btn--settings-off")) {
        for (var i = 0; i < qualities.length; i++) {
          createQualityOptions(qualities[i], i);
        }
        btnSettings.classList.remove("btn--settings-off");
        btnSettings.classList.add("btn--settings-on");
        settingsMenu.classList.add("open");
      } else {
        closeSettingsMenu();
      }
    },
    false
  );

  // Close Settings menu if user clicks outside the player
  window.addEventListener("click", function (e) {
    if (playerOverlay.contains(e.target)) {
    } else {
      closeSettingsMenu();
    }
  });

  // Clip
  btnClip.addEventListener(
    "click",
    function (e) {
      createClip();
    },
    false
  );

  // Close clip
  closeClip.addEventListener(
    "click",
    function () {
      removeClip();
    },
    false
  );

  // Create Clip
  let createClip = function (time) {
    clipPlayer.setAttribute("src", "");
    clipPlayer.classList.remove("show");

    const url = endpoints.clip;

    var call = new XMLHttpRequest();
    call.responseType = "json";
    call.open("POST", url, true);
    call.onload = function () {
      clipSrc = call.response.URL;

      setTimeout(function () {
        displayClip(clipSrc);
      }, 150);
    };
    call.send("null");
  };

  // Display Clip
  let displayClip = function (src) {
    clipPlayer.setAttribute("src", src);
    clipPlayer.classList.add("show");
    clipPlayer.load();
    clipPlayer.play();
    player.setMuted(1);
    player.pause();
  };

  // Remove Clip
  let removeClip = function () {
    clipPlayer.setAttribute("src", "");
    clipPlayer.classList.remove("show");
    player.setMuted(0);
    player.play();
  };

  let logLatency = function () {
    console.log(player.getLiveLatency());
  };

  setInterval(logLatency, 5000);
})(window.IVSPlayer);
