package server

import (
	"code.justin.tv/event-engineering/golibs/pkg/logging"
	gortmp "code.justin.tv/event-engineering/gortmp/pkg/rtmp"
	pusher "code.justin.tv/event-engineering/rtmp/pkg/pusher"
	"code.justin.tv/event-engineering/rtmp/pkg/server"
	"context"
	"net"
)

type Server interface {
	Start() error
}

type rtmpServer struct {
	sv     *server.Server
	ln     net.Listener
	logger logging.Logger
}

func New(logger logging.Logger) Server {
	return &rtmpServer{
		logger: logger,
	}
}

func (s *rtmpServer) Start() error {
	ms := server.NewMediaServer(&handler{
		logger: s.logger,
		server: s,
	})

	s.sv = server.NewServer(server.ServerConfig{
		Context: context.Background(),
		Handler: ms,
		Logger:  s.logger,
	})

	ln, err := net.Listen("tcp", net.JoinHostPort("0.0.0.0", "1935"))
	if err != nil {
		return err
	}

	s.ln = ln

	s.sv.Serve(ln)

	return nil
}

type handler struct {
	logger logging.Logger
	server *rtmpServer

	pusher *pusher.Pusher
}

func (h *handler) OnMediaStreamCreated(ctx context.Context, ms gortmp.MediaStream) {
	errCh := make(chan error)

	p := pusher.NewPusher(errCh, h.logger)

}

func (h *handler) OnMediaStreamDestroyed(ctx context.Context, ms gortmp.MediaStream) {

}

func (h *handler) Handle(ctx context.Context, r gortmp.Receiver, msg gortmp.Message) error {
	return r.Handle(msg)
}
