#!/bin/bash

# This script is designed to push an 720p60 ENCODE stream to a channel in a loop based on a file


FFMPEG="/usr/local/bin/ffmpeg"
FILE="~/Movies/stream-push/TestFootage.ts"
RTMP="rtmp://live.twitch.tv/app"
# this key is for s4sh
STREAMKEY="###"


#reference line ffmpeg -re -stream_loop 0 -i TestFootage.ts -c:v copy -c:a aac -strict 2 -f flv rtmp://live-lax.twitch.tv/app/STREAMKEY


echo "Starting test ENCODE stream 720p@4200Kbps with file $FILE now"
$FFMPEG -re -stream_loop -1 \
-i $FILE \
-s 1280x720 -preset veryfast -vcodec libx264 \
-x264opts bitrate=4200:nal-hrd=cbr -pix_fmt yuv420p -maxrate 4200k -bufsize 4200k -force_key_frames expr:gte\(\t,\n_forced*\2\) \
-acodec aac -ab 160k -ac 2 -ar 44100 \
-f flv "$RTMP/$STREAMKEY"

#if you prefer for the process to run in the background add
  #> /dev/null 2>/dev/null &
