#!/bin/bash

#FILE NAME FOR TEST
FILETEST="MERGED-1080p60-X264-MPEGTS.ts"

# each ingest/stream key, with quotes, and a space inbetween
dests=(
  "live-fra live_177204322_q6maq1BuAmSQk4YKL9KT18II8wwrKq"
)

if ! [[ -f $FILETEST ]]; then
  wget http://twitch-video-scratch-public.s3.amazonaws.com/aom-footage/run-test/MERGED-1080p60-X264-MPEGTS.ts
fi

run-stream() {
  local ingest=$1 stream_key=$2
  echo "$(date): initializing loop for $ingest $stream_key"
  while [[ -f keep-streaming ]]; do
    echo "$(date): starting stream for $ingest $stream_key"
    ffmpeg -re -stream_loop -1 -i $FILETEST -c:v copy -c:a aac -strict 2 -f flv rtmp://$ingest.twitch.tv/app/$stream_key >> log-$ingest-$stream_key.txt 2>&1
  done
}

touch keep-streaming
trap "rm -f keep-streaming" EXIT

for dest in "${dests[@]}"; do
  ingest="${dest%% *}"
  stream_key="${dest#* }"
  run-stream $ingest $stream_key &
done

while sleep 1000; do
  true
done
