#!/bin/bash
cd "$(dirname "$0")"

host="$1"
path="$2"
ip="$3"
args="$4"

if [ -z "$host" ]
	then
	echo "No host supplied"
	exit
fi

if [ -z "$path" ]
	then
	echo "No path supplied"
	exit
fi

if [ -z "$ip" ]
        then
        ip=${host}
fi

if [ -z "$args" ]
        then
        args=-I
fi

echo "curl --compressed -H 'Host: ${host}' -H 'Accept-Encoding: gzip, deflate, sdch, br' -H 'Connection: keep-alive' --cookie 'language=en' -k https://${ip}/${path} ${args}"
curl --compressed -H 'Host: '"${host}" -H 'Accept-Encoding: gzip, deflate, sdch, br' -H 'Connection: keep-alive' --cookie 'language=en' -k https://${ip}/${path} ${args}
