#!/usr/bin/env node
import cdk = require('@aws-cdk/core');
import { ShitsonfireyoStack } from '../lib/shitsonfireyo-stack';

const app = new cdk.App();
new ShitsonfireyoStack(app, 'ShitsOnFireYo-stg', {
  vpcId: 'vpc-52e02435',
  cdk: {
    env: {
      account: '152548578290',
      region: 'us-west-2'
    }
  },
  targets: [
    // These are pulled from provisioner
    "10.23.7.221", "10.23.77.224", "10.23.77.228", "10.23.77.225", "10.23.77.238", "10.23.77.223", "10.23.77.226", "10.23.79.211", "10.23.79.215", "10.23.79.242", "10.23.79.248", "10.23.79.214", "10.23.79.241", "10.23.10.245", "10.23.2.225", "10.23.2.182", "10.23.2.168", "10.23.2.164", "10.23.2.10", "10.23.4.11", "10.23.4.10", "10.23.4.9", "10.23.4.110", "10.23.4.228", "10.23.4.212", "10.23.4.167", "10.23.6.108", "10.23.8.8", "10.23.10.227", "10.23.12.226", "10.23.12.61", "10.23.12.99", "10.23.12.137", "10.23.12.138", "10.23.14.244", "10.23.16.205", "10.23.16.204", "10.23.16.207", "10.23.16.206", "10.23.16.201", "10.23.16.200", "10.23.16.203", "10.23.16.111", "10.23.16.217", "10.23.16.105", "10.23.16.177", "10.23.16.110", "10.23.16.104", "10.23.16.107", "10.23.16.108", "10.23.16.202", "10.23.16.106", "10.23.16.180", "10.23.16.181", "10.23.16.183", "10.23.16.84", "10.23.16.85", "10.23.16.182", "10.23.16.87", "10.23.14.207", "10.23.7.68", "10.23.7.71", "10.23.7.161", "10.23.7.160", "10.23.7.163", "10.23.7.162", "10.23.7.70", "10.23.7.173", "10.23.7.65", "10.23.7.64", "10.23.7.172", "10.23.70.182", "10.23.76.165", "10.23.76.172", "10.23.76.186", "10.23.76.174", "10.23.76.196", "10.23.76.185"
  ]
});

new ShitsonfireyoStack(app, 'ShitsOnFireYo-prod', {
  vpcId: 'vpc-23fa3f44',
  cdk: {
    env: {
      account: '277437172290',
      region: 'us-west-2'
    }
  },
  targets: [
    // These are pulled from provisioner
    "10.23.7.221", "10.23.77.224", "10.23.77.228", "10.23.77.225", "10.23.77.238", "10.23.77.223", "10.23.77.226", "10.23.79.211", "10.23.79.215", "10.23.79.242", "10.23.79.248", "10.23.79.214", "10.23.79.241", "10.23.10.245", "10.23.2.225", "10.23.2.182", "10.23.2.168", "10.23.2.164", "10.23.2.10", "10.23.4.11", "10.23.4.10", "10.23.4.9", "10.23.4.110", "10.23.4.228", "10.23.4.212", "10.23.4.167", "10.23.6.108", "10.23.8.8", "10.23.10.227", "10.23.12.226", "10.23.12.61", "10.23.12.99", "10.23.12.137", "10.23.12.138", "10.23.14.244", "10.23.16.205", "10.23.16.204", "10.23.16.207", "10.23.16.206", "10.23.16.201", "10.23.16.200", "10.23.16.203", "10.23.16.111", "10.23.16.217", "10.23.16.105", "10.23.16.177", "10.23.16.110", "10.23.16.104", "10.23.16.107", "10.23.16.108", "10.23.16.202", "10.23.16.106", "10.23.16.180", "10.23.16.181", "10.23.16.183", "10.23.16.84", "10.23.16.85", "10.23.16.182", "10.23.16.87", "10.23.14.207", "10.23.7.68", "10.23.7.71", "10.23.7.161", "10.23.7.160", "10.23.7.163", "10.23.7.162", "10.23.7.70", "10.23.7.173", "10.23.7.65", "10.23.7.64", "10.23.7.172", "10.23.70.182", "10.23.76.165", "10.23.76.172", "10.23.76.186", "10.23.76.174", "10.23.76.196", "10.23.76.185"
  ]
});
