import cdk = require('@aws-cdk/core');
import elb = require('@aws-cdk/aws-elasticloadbalancingv2');
import ec2 = require('@aws-cdk/aws-ec2');

export interface Props {
  vpcId: string,
  cdk: cdk.StackProps,
  targets: string[],
}

export class ShitsonfireyoStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: Props) {
    super(scope, id, props.cdk);

    const vpcRef = ec2.Vpc.fromLookup(this, 'VpcRef', {
      vpcId: props.vpcId,
    })

    const nlb = new elb.NetworkLoadBalancer(this, 'EmergencyRTMPRelay', {
      vpc: vpcRef,
      internetFacing: true,
      loadBalancerName: 'EmergencyRTMPRelayNLB',
    })

    const lbTierTargetGroup = new elb.NetworkTargetGroup(this, 'EmergencyRTMPRelayIngestProxyLBTarget', {
      vpc: vpcRef,
      port: 1935,
      targetType: elb.TargetType.IP,
    })

    nlb.addListener('EmergencyRTMPRelayListener', {
      port: 1935,
      defaultTargetGroups: [lbTierTargetGroup],
    })

    for (var target of props.targets) {
      lbTierTargetGroup.addTarget(new elb.IpTarget(target, 1935, "all"))
    }
  }
}
