package auth

import (
	"context"
	"net/http"
)

type dummy struct {
	login string
}

// NewDummyAuth creates a dummy auth handler that uses the identity of the passed in user, for working locally
func NewDummyAuth(login string) Auth {
	return &dummy{
		login: login,
	}
}

func (a *dummy) Handler(inner http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		inner.ServeHTTP(w, r.WithContext(context.WithValue(r.Context(), keyAmznLogin, a.login)))
	})
}
