package auth

import (
	"context"
	"net/http"

	"code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	"github.com/dgrijalva/jwt-go"
	"github.com/sirupsen/logrus"
)

type midway struct {
	logger logrus.FieldLogger
}

// NewMidwayAuth creates an auth handler for use with TrivEA midway
func NewMidwayAuth(logger logrus.FieldLogger) Auth {
	return &midway{
		logger: logger,
	}
}

func (a *midway) Handler(inner http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		ctx := r.Context()

		var token string

		if lambdaCtx, ok := lambda.RequestContext(ctx); ok && lambdaCtx.Authorizer["oidc-data"] != nil {
			token = lambdaCtx.Authorizer["oidc-data"].(string)
		} else {
			cookie, err := r.Cookie("amzn_sso_token")

			if err != nil {
				a.logger.WithError(err).Warn("Error getting cookie amzn_sso_token")
			} else {
				token = cookie.Value
			}
		}

		if token == "" {
			a.logger.Warn("JWT token not found")
			w.WriteHeader(401)
			return
		}

		// TrivEA is the only thing calling this function and token validation is done there, so we're just gonna parse it to get the username
		jwt.Parse(token, func(token *jwt.Token) (interface{}, error) {
			if claims, ok := token.Claims.(jwt.MapClaims); ok {
				userID := claims["sub"].(string)

				ctx = context.WithValue(ctx, keyAmznLogin, userID)
			}

			r = r.WithContext(ctx)

			return "", nil
		})

		inner.ServeHTTP(w, r)
	})
}
