package accountviewer

import (
	"net/http"

	cc "code.justin.tv/event-engineering/carrot-control/pkg/rpc"
	"github.com/sirupsen/logrus"
	goji "goji.io"
)

type handler struct {
	mux    *goji.Mux
	cc     cc.CarrotControl
	logger logrus.FieldLogger
}

// NewAccountViewerHandler will forward channelviewer API requests to the carrot control service
func NewAccountViewerHandler(carrotControl cc.CarrotControl, logger logrus.FieldLogger) http.Handler {
	handler := &handler{
		mux:    goji.NewMux(),
		logger: logger,
		cc:     carrotControl,
	}

	// We used to have limit breaches here but that moved to its own module, so currently there are no accountviewer
	// API calls but I'm leaving this here because there's probably going to be some in future

	return handler.mux
}
