package limitbreaches

import (
	"net/http"

	sec "code.justin.tv/amzn/StarfruitSECTwirp"
	cc "code.justin.tv/event-engineering/carrot-control/pkg/rpc"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/util"
	"github.com/sirupsen/logrus"
	goji "goji.io"
	"goji.io/pat"
)

type handler struct {
	mux    *goji.Mux
	cc     cc.CarrotControl
	logger logrus.FieldLogger
}

// NewLimitBreachesHandler will forward limitbreaches API requests to the carrot control service
func NewLimitBreachesHandler(carrotControl cc.CarrotControl, logger logrus.FieldLogger) http.Handler {
	handler := &handler{
		mux:    goji.NewMux(),
		logger: logger,
		cc:     carrotControl,
	}

	handler.mux.HandleFunc(pat.New("/:customer_id/:region"), handler.ListLimitBreaches)

	return handler.mux
}

func (s *handler) ListLimitBreaches(writer http.ResponseWriter, request *http.Request) {
	customerID := pat.Param(request, "customer_id")
	region := pat.Param(request, "region")
	sessionID := request.URL.Query().Get("session_id")
	pageToken := request.URL.Query().Get("page_token")

	s.logger.Debugf("Calling ListLimitBreachEvents with customerID %v, region %v and sessionID %v", customerID, region, sessionID)
	resp, err := s.cc.ListLimitBreachEvents(request.Context(), &cc.ListLimitBreachEventsRequest{
		Region: region,
		Request: &sec.ListLimitBreachEventsRequest{
			CustomerId: customerID,
			PageToken:  pageToken,
			SessionId:  sessionID,
			PageSize:   10,
		},
	})

	util.HandleResponse(writer, resp, err)
}
