package modules

import (
	"net/http"

	cc "code.justin.tv/event-engineering/carrot-control/pkg/rpc"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/modules/limitbreaches"
	"github.com/sirupsen/logrus"
	goji "goji.io"
	"goji.io/pat"

	"code.justin.tv/event-engineering/starfruit-support-portal/app/modules/accountviewer"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/modules/channelviewer"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/modules/omnibar"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/modules/reports"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/modules/servicehealth"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/modules/sessionviewer"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/modules/videoanalysis"
)

// AddModules will set up each module of the application, registering its paths
func AddModules(mux *goji.Mux, carrotControl cc.CarrotControl, logger logrus.FieldLogger) {
	addSessionViewer(mux, carrotControl, logger)
	addAccountViewer(mux, carrotControl, logger)
	addLimitBreaches(mux, carrotControl, logger)
	addChannelViewer(mux, carrotControl, logger)
	addReports(mux, carrotControl, logger)
	addServiceHealth(mux, carrotControl, logger)
	addVideoAnalysis(mux, carrotControl, logger)
	addOmnibar(mux, carrotControl, logger)
}

func addOmnibar(mux *goji.Mux, carrotControl cc.CarrotControl, logger logrus.FieldLogger) {
	server := omnibar.NewOmnibarHandler(carrotControl, logger)

	mux.Handle(pat.New("/omnibar/*"), http.StripPrefix("/omnibar", server))
}

func addSessionViewer(mux *goji.Mux, carrotControl cc.CarrotControl, logger logrus.FieldLogger) {
	server := sessionviewer.NewSessionViewerHandler(carrotControl, logger)

	mux.Handle(pat.New("/sessionviewer/*"), http.StripPrefix("/sessionviewer", server))
}

func addAccountViewer(mux *goji.Mux, carrotControl cc.CarrotControl, logger logrus.FieldLogger) {
	server := accountviewer.NewAccountViewerHandler(carrotControl, logger)

	mux.Handle(pat.New("/account/*"), http.StripPrefix("/account", server))
}

func addLimitBreaches(mux *goji.Mux, carrotControl cc.CarrotControl, logger logrus.FieldLogger) {
	server := limitbreaches.NewLimitBreachesHandler(carrotControl, logger)

	mux.Handle(pat.New("/limit_breaches/*"), http.StripPrefix("/limit_breaches", server))
}

func addChannelViewer(mux *goji.Mux, carrotControl cc.CarrotControl, logger logrus.FieldLogger) {
	server := channelviewer.NewChannelViewerHandler(carrotControl, logger)

	mux.Handle(pat.New("/channelviewer/*"), http.StripPrefix("/channelviewer", server))
}

func addReports(mux *goji.Mux, carrotControl cc.CarrotControl, logger logrus.FieldLogger) {
	server := reports.NewReportsHandler(carrotControl, logger)

	mux.Handle(pat.New("/reports/*"), http.StripPrefix("/reports", server))
}

func addServiceHealth(mux *goji.Mux, carrotControl cc.CarrotControl, logger logrus.FieldLogger) {
	server := servicehealth.NewServiceHealthHandler(carrotControl, logger)

	mux.Handle(pat.New("/health/*"), http.StripPrefix("/health", server))
}

func addVideoAnalysis(mux *goji.Mux, carrotControl cc.CarrotControl, logger logrus.FieldLogger) {
	server := videoanalysis.NewVideoAnalysisHandler(carrotControl, logger)

	mux.Handle(pat.New("/videoanalysis/*"), http.StripPrefix("/videoanalysis", server))
}
