package omnibar

import (
	"net/http"

	cc "code.justin.tv/event-engineering/carrot-control/pkg/rpc"
	rpc "code.justin.tv/event-engineering/carrot-omnibar/pkg/rpc"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/util"
	"github.com/sirupsen/logrus"
	goji "goji.io"
	"goji.io/pat"
)

type handler struct {
	mux    *goji.Mux
	logger logrus.FieldLogger
	cc     cc.CarrotControl
}

// NewOmnibarHandler will forward API requests to the omnibar lambda function
func NewOmnibarHandler(carrotControl cc.CarrotControl, logger logrus.FieldLogger) http.Handler {
	handler := &handler{
		mux:    goji.NewMux(),
		logger: logger,
		cc: carrotControl,
	}

	handler.mux.HandleFunc(pat.Get("/whatis"), handler.WhatIsThisThing)

	return handler.mux
}

func (s *handler) WhatIsThisThing(writer http.ResponseWriter, request *http.Request) {
	thing := request.URL.Query().Get("thisthing")

	resp, err := s.cc.WhatIs(request.Context(), &rpc.This{
		Thing: thing,
	})

	util.HandleResponse(writer, resp, err)
}
