package servicehealth

import (
	"net/http"

	cc "code.justin.tv/event-engineering/carrot-control/pkg/rpc"
	csh "code.justin.tv/event-engineering/carrot-system-health/pkg/rpc"
	"code.justin.tv/event-engineering/starfruit-support-portal/app/util"
	"github.com/sirupsen/logrus"
	goji "goji.io"
	"goji.io/pat"
)

type handler struct {
	mux    *goji.Mux
	cc     cc.CarrotControl
	logger logrus.FieldLogger
}

// NewServiceHealthHandler will forward servicehealth API requests to the carrot control service
func NewServiceHealthHandler(carrotControl cc.CarrotControl, logger logrus.FieldLogger) http.Handler {
	handler := &handler{
		mux:    goji.NewMux(),
		logger: logger,
		cc:     carrotControl,
	}

	handler.mux.HandleFunc(pat.New("/pop"), handler.GetPoPHealth)

	return handler.mux
}

func (s *handler) GetPoPHealth(writer http.ResponseWriter, request *http.Request) {

	s.logger.Debug("Calling GetPoPHealth")
	resp, err := s.cc.GetPoPHealth(request.Context(), &csh.GetPoPHealthRequest{})

	util.HandleResponse(writer, resp, err)
}
