package util

import (
	"fmt"
)

type TimeZone struct {
	Name string `json:"name"`
	Offset string `json:"offset"`
	OffsetMinutes int `json:"offset_minutes"`
}

func ListTimeZones() ([]*TimeZone) {
	var res []*TimeZone
	// There's just so many actual time zones (like more than 500) that I'm just going to do a list of offsets instead
	for i := -12; i <= 12; i++ {
		res = append(res, &TimeZone{
			Name: fmt.Sprintf("UTC %+03d:00", i),
			OffsetMinutes: i * 60,
		})
	}

	return res
}
