#!/usr/bin/env node
import cdk = require('@aws-cdk/core');
import { PortalAppStack } from '../lib/portal-stack';

const app = new cdk.App();
new PortalAppStack(app, 'support-portal-stg', {
  cdkProps: {
    stackName: 'support-portal-stg',
    env: {
      account: '134277936734',
      region: 'us-west-2'
    }
  },
  portalAppProps: {
    vpcId: 'vpc-0ba8a2483a591a259',
    trivEAARN: 'arn:aws:execute-api:us-west-2:141456490005:fkfl6c4g12/live/*/*',
    carrotControlLambdaARN: 'arn:aws:lambda:us-west-2:134277936734:function:carrot-control-stg-CarrotControl89B6CA77-3BP4UEI0KLVD',
    carrotControlClientID: 'starfruit-support-portal-stg',
  }
});

new PortalAppStack(app, 'support-portal-prod', {
  cdkProps: {
    stackName: 'support-portal-prod',
    env: {
      account: '782947612856',
      region: 'us-west-2'
    },
    terminationProtection: true,
  },
  portalAppProps: {
    vpcId: 'vpc-094f73121cb30db65',
    trivEAARN: 'arn:aws:execute-api:us-west-2:141456490005:5nkyttpm3h/live/*/*',
    carrotControlLambdaARN: 'arn:aws:lambda:us-west-2:782947612856:function:carrot-control-prod-CarrotControl89B6CA77-1H9WUEHKXIPJT',
    carrotControlClientID: 'starfruit-support-portal-prod',
  }
});
