import iam = require('@aws-cdk/aws-iam');
import cdk = require('@aws-cdk/core');

export class CapacityCdk extends cdk.Construct {
  constructor(scope: cdk.Construct, id: string) {
    super(scope, id);

    const twitchInventoryRole = new iam.Role(this, "TwitchInventoryRole", {
      roleName: 'twitch-inventory',
      assumedBy: new iam.ArnPrincipal("arn:aws:iam::578510050023:role/twitch-inventory-master"),
      managedPolicies: [
        iam.ManagedPolicy.fromAwsManagedPolicyName("ReadOnlyAccess"),
        iam.ManagedPolicy.fromAwsManagedPolicyName("AWSSupportAccess"),
      ],
    })

    new iam.Policy(this, "CostExplorerPolicy", {
      policyName: 'twitch-inventory-cost-explorer',
      statements: [
        new iam.PolicyStatement({
          effect: iam.Effect.ALLOW,
          actions: ["ce:*"],
          resources: ["*"],
        }
      )],
      roles: [twitchInventoryRole],
    })
  }
}
